/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.client.particles;

import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class ParticleFluidXP
extends TextureSheetParticle {
    private final SpriteSet sprites;

    public ParticleFluidXP(ClientLevel world, double x, double y, double z, double tx, double ty, double tz, int count, int color, float scale, SpriteSet sprite) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.sprites = sprite;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        Color c = new Color(color);
        float mr = (float)c.getRed() / 255.0f * 0.2f;
        float mg = (float)c.getGreen() / 255.0f * 0.2f;
        float mb = (float)c.getBlue() / 255.0f * 0.2f;
        this.rCol = (float)c.getRed() / 255.0f - mr + this.random.nextFloat() * mr;
        this.gCol = (float)c.getGreen() / 255.0f - mg + this.random.nextFloat() * mg;
        this.bCol = (float)c.getBlue() / 255.0f - mb + this.random.nextFloat() * mb;
        this.gravity = 0.01f;
        this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.quadSize = (Mth.sin((float)((float)count / 2.0f)) * 0.1f + 1.0f) * scale;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.yd -= (double)this.gravity;
        this.move(this.xd, this.yd, this.zd);
        this.yd *= (double)0.98f;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
    }

    @Nonnull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public int getLightColor(float partialTicks) {
        return 0xF000F0;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        SpriteSet sprites;

        public Factory(SpriteSet sprite) {
            this.sprites = sprite;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleFluidXP particle = new ParticleFluidXP(world, x + world.random.nextDouble() - 0.025, y + 0.125, z + world.random.nextDouble() - 0.025, xSpeed, ySpeed, zSpeed, 20, 0xFFFF00, 0.125f, this.sprites);
            particle.pickSprite(this.sprites);
            return particle;
        }
    }
}

