/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import java.util.Locale;
import javax.annotation.Nonnull;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.blocks.BlockEnderInhibitorOff;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockEnderInhibitorOn
extends Block {
    public static final EnumProperty<EnumGemDirection> TYPE = EnumProperty.create((String)"type", EnumGemDirection.class);
    public static final VoxelShape DOWN_NORTH_AABB = Block.box((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)3.0, (double)13.0);
    public static final VoxelShape DOWN_SOUTH_AABB = Block.box((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)3.0, (double)13.0);
    public static final VoxelShape DOWN_WEST_AABB = Block.box((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)3.0, (double)14.0);
    public static final VoxelShape DOWN_EAST_AABB = Block.box((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)3.0, (double)14.0);
    public static final VoxelShape UP_NORTH_AABB = Block.box((double)2.0, (double)13.0, (double)3.0, (double)14.0, (double)16.0, (double)13.0);
    public static final VoxelShape UP_SOUTH_AABB = Block.box((double)2.0, (double)13.0, (double)3.0, (double)14.0, (double)16.0, (double)13.0);
    public static final VoxelShape UP_WEST_AABB = Block.box((double)3.0, (double)13.0, (double)2.0, (double)13.0, (double)16.0, (double)14.0);
    public static final VoxelShape UP_EAST_AABB = Block.box((double)3.0, (double)13.0, (double)2.0, (double)13.0, (double)16.0, (double)14.0);
    public static final VoxelShape NORTH_AABB = Block.box((double)2.0, (double)3.0, (double)0.0, (double)14.0, (double)13.0, (double)3.0);
    public static final VoxelShape SOUTH_AABB = Block.box((double)2.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0, (double)16.0);
    public static final VoxelShape WEST_AABB = Block.box((double)0.0, (double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)14.0);
    public static final VoxelShape EAST_AABB = Block.box((double)13.0, (double)3.0, (double)2.0, (double)16.0, (double)13.0, (double)14.0);

    public BlockEnderInhibitorOn(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(TYPE, (Comparable)((Object)EnumGemDirection.DOWN_NORTH)));
    }

    @Nonnull
    public RenderShape getRenderShape(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(@Nonnull BlockState stateIn, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        for (int i = 0; i < 4; ++i) {
            double d0 = (float)pos.getX() + rand.nextFloat();
            double d1 = (float)pos.getY() + rand.nextFloat();
            double d2 = (float)pos.getZ() + rand.nextFloat();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (world.getBlockState(pos.west()).getBlock() != this && world.getBlockState(pos.east()).getBlock() != this) {
                d0 = (double)pos.getX() + 0.5 + 0.25 * (double)j;
                d3 = rand.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.getZ() + 0.5 + 0.25 * (double)j;
                d5 = rand.nextFloat() * 2.0f * (float)j;
            }
            world.addParticle((ParticleOptions)ParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5);
        }
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return switch (((EnumGemDirection)((Object)state.getValue(TYPE))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 9 -> SOUTH_AABB;
            case 8 -> NORTH_AABB;
            case 11 -> EAST_AABB;
            case 10 -> WEST_AABB;
            case 4 -> UP_NORTH_AABB;
            case 7 -> UP_EAST_AABB;
            case 5 -> UP_SOUTH_AABB;
            case 6 -> UP_WEST_AABB;
            case 0 -> DOWN_NORTH_AABB;
            case 3 -> DOWN_EAST_AABB;
            case 1 -> DOWN_SOUTH_AABB;
            case 2 -> DOWN_WEST_AABB;
        };
    }

    @Nonnull
    public VoxelShape getInteractionShape(BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        return switch (((EnumGemDirection)((Object)state.getValue(TYPE))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 9 -> SOUTH_AABB;
            case 8 -> NORTH_AABB;
            case 11 -> EAST_AABB;
            case 10 -> WEST_AABB;
            case 4 -> UP_NORTH_AABB;
            case 7 -> UP_EAST_AABB;
            case 5 -> UP_SOUTH_AABB;
            case 6 -> UP_WEST_AABB;
            case 0 -> DOWN_NORTH_AABB;
            case 3 -> DOWN_EAST_AABB;
            case 1 -> DOWN_SOUTH_AABB;
            case 2 -> DOWN_WEST_AABB;
        };
    }

    public void neighborChanged(BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos, boolean isMoving) {
        EnumGemDirection newFacing = (EnumGemDirection)((Object)state.getValue(TYPE));
        boolean flag = false;
        if ((newFacing == EnumGemDirection.UP_NORTH || newFacing == EnumGemDirection.UP_EAST || newFacing == EnumGemDirection.UP_SOUTH || newFacing == EnumGemDirection.UP_WEST) && world.getBlockState(pos.above()).isFaceSturdy((BlockGetter)world, pos.above(), Direction.DOWN, SupportType.RIGID)) {
            flag = true;
        }
        if ((newFacing == EnumGemDirection.DOWN_NORTH || newFacing == EnumGemDirection.DOWN_EAST || newFacing == EnumGemDirection.DOWN_SOUTH || newFacing == EnumGemDirection.DOWN_WEST) && world.getBlockState(pos.below()).isFaceSturdy((BlockGetter)world, pos.below(), Direction.UP, SupportType.RIGID)) {
            flag = true;
        }
        if (newFacing == EnumGemDirection.NORTH && world.getBlockState(pos.relative(Direction.NORTH)).isFaceSturdy((BlockGetter)world, pos.relative(Direction.NORTH), Direction.NORTH, SupportType.RIGID)) {
            flag = true;
        }
        if (newFacing == EnumGemDirection.SOUTH && world.getBlockState(pos.relative(Direction.SOUTH)).isFaceSturdy((BlockGetter)world, pos.relative(Direction.SOUTH), Direction.SOUTH, SupportType.RIGID)) {
            flag = true;
        }
        if (newFacing == EnumGemDirection.WEST && world.getBlockState(pos.relative(Direction.WEST)).isFaceSturdy((BlockGetter)world, pos.relative(Direction.WEST), Direction.WEST, SupportType.RIGID)) {
            flag = true;
        }
        if (newFacing == EnumGemDirection.EAST && world.getBlockState(pos.relative(Direction.EAST)).isFaceSturdy((BlockGetter)world, pos.relative(Direction.EAST), Direction.EAST, SupportType.RIGID)) {
            flag = true;
        }
        if (!flag) {
            BlockEnderInhibitorOn.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModBlocks.ENDER_INHIBITOR_OFF.getItem(), 1));
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
        super.neighborChanged(state, world, pos, block, fromPos, isMoving);
    }

    @Nonnull
    public InteractionResult useWithoutItem(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull BlockHitResult hitResult) {
        if (!world.isClientSide) {
            BlockState activeState = (BlockState)ModBlocks.ENDER_INHIBITOR_OFF.getBlock().defaultBlockState().setValue((Property)BlockEnderInhibitorOff.TYPE, (Comparable)((Object)((EnumGemDirection)((Object)state.getValue(TYPE)))));
            world.setBlock(pos, activeState, 3);
            world.playSound(null, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.3f, 0.6f);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean canSurvive(@Nonnull BlockState state, @Nonnull LevelReader world, @Nonnull BlockPos pos) {
        for (Direction enumfacing : Direction.values()) {
            if (!BlockEnderInhibitorOn.canSupportCenter((LevelReader)world, (BlockPos)pos.relative(enumfacing.getOpposite()), (Direction)enumfacing)) continue;
            return true;
        }
        return false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getClickedFace();
        Direction direction = context.getPlayer().getDirection();
        EnumGemDirection newFacing = EnumGemDirection.DOWN_NORTH;
        if (facing == Direction.UP) {
            newFacing = switch (direction) {
                case Direction.SOUTH -> EnumGemDirection.DOWN_SOUTH;
                case Direction.EAST -> EnumGemDirection.DOWN_WEST;
                case Direction.NORTH -> EnumGemDirection.DOWN_NORTH;
                case Direction.WEST -> EnumGemDirection.DOWN_EAST;
                default -> newFacing;
            };
        } else if (facing == Direction.DOWN) {
            newFacing = switch (direction) {
                case Direction.SOUTH -> EnumGemDirection.UP_SOUTH;
                case Direction.EAST -> EnumGemDirection.UP_WEST;
                case Direction.NORTH -> EnumGemDirection.UP_NORTH;
                case Direction.WEST -> EnumGemDirection.UP_EAST;
                default -> newFacing;
            };
        } else {
            newFacing = switch (facing) {
                case Direction.SOUTH -> EnumGemDirection.NORTH;
                case Direction.EAST -> EnumGemDirection.WEST;
                case Direction.NORTH -> EnumGemDirection.SOUTH;
                case Direction.WEST -> EnumGemDirection.EAST;
                default -> newFacing;
            };
        }
        return (BlockState)this.defaultBlockState().setValue(TYPE, (Comparable)((Object)newFacing));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TYPE});
    }

    public static enum EnumGemDirection implements StringRepresentable
    {
        DOWN_NORTH,
        DOWN_SOUTH,
        DOWN_WEST,
        DOWN_EAST,
        UP_NORTH,
        UP_SOUTH,
        UP_WEST,
        UP_EAST,
        NORTH,
        SOUTH,
        WEST,
        EAST;


        @Nonnull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

