/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.tileentities;

import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.storage.StructurePackMeta;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.BlockInfo;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.compatibility.newstruct.BlueprintMapping;
import com.minecolonies.api.inventory.api.CombinedItemHandler;
import com.minecolonies.api.inventory.container.ContainerBuildingInventory;
import com.minecolonies.api.items.component.ColonyId;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.tileentities.ITickable;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.WorldUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityColonyBuilding
extends AbstractTileEntityColonyBuilding
implements ITickable {
    private static final String TAG_COLONY = "colony";
    private static final String TAG_MIRROR = "mirror";
    private static final String TAG_STYLE = "style";
    private static final String TAG_PACK = "pack";
    private static final String TAG_PATH = "path";
    private int colonyId = 0;
    private IColony colony;
    private IBuilding building;
    @Nullable
    private RotationMirror rotationMirror;
    private String packMeta = "";
    private String path = "";
    public ResourceLocation registryName;
    private CombinedItemHandler combinedInv;
    private Future<Blueprint> pendingBlueprintFuture = null;

    public TileEntityColonyBuilding(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends AbstractTileEntityColonyBuilding>)((BlockEntityType)MinecoloniesTileEntities.BUILDING.get()), pos, state);
    }

    public TileEntityColonyBuilding(BlockEntityType<? extends AbstractTileEntityColonyBuilding> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public int getColonyId() {
        return this.colonyId;
    }

    @Override
    public IColony getColony() {
        if (this.colony == null) {
            this.updateColonyReferences();
        }
        return this.colony;
    }

    private void updateColonyReferences() {
        if (this.colony == null && this.getLevel() != null) {
            this.colony = this.colonyId == 0 ? IColonyManager.getInstance().getColonyByPosFromWorld(this.getLevel(), this.getBlockPos()) : IColonyManager.getInstance().getColonyByWorld(this.colonyId, this.getLevel());
            if (this.colony != null || !this.getLevel().isClientSide) {
                // empty if block
            }
        }
        if (this.building == null && this.colony != null) {
            this.building = this.colony.getBuildingManager().getBuilding(this.getPosition());
            if (!(this.building == null || this.getLevel() != null && this.getLevel().isClientSide)) {
                this.registryName = this.building.getBuildingType().getRegistryName();
                this.building.setTileEntity(this);
            }
        }
    }

    @Override
    public BlockPos getPosition() {
        return this.worldPosition;
    }

    @Override
    @Nullable
    public BlockPos getPositionOfChestWithItemStack(@NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        Predicate<ItemStack> notEmptyPredicate = itemStackSelectionPredicate.and(ItemStackUtils.NOT_EMPTY_PREDICATE);
        @Nullable IBuilding theBuilding = this.getBuilding();
        if (theBuilding != null) {
            for (BlockPos pos : theBuilding.getContainers()) {
                AbstractTileEntityRack rack;
                BlockEntity entity;
                if (!WorldUtil.isBlockLoaded((LevelAccessor)this.level, pos) || !((entity = this.getLevel().getBlockEntity(pos)) instanceof AbstractTileEntityRack) || !(rack = (AbstractTileEntityRack)entity).hasItemStack(notEmptyPredicate)) continue;
                return pos;
            }
        }
        return null;
    }

    @Override
    public void setColony(IColony c) {
        this.colony = c;
        this.colonyId = c.getID();
        this.setChanged();
    }

    @Override
    public void setChanged() {
        super.setChanged();
        if (this.building != null) {
            this.building.markDirty();
        }
    }

    @Override
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        return this.saveWithId(provider);
    }

    @Override
    public void handleUpdateTag(CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        this.loadAdditional(tag, provider);
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, @NotNull HolderLookup.Provider provider) {
        CompoundTag compound = packet.getTag();
        this.colonyId = compound.getInt(TAG_COLONY);
        super.onDataPacket(net, packet, provider);
    }

    public void onLoad() {
        if (this.building != null) {
            this.building.setTileEntity(null);
        }
    }

    @Override
    public IBuilding getBuilding() {
        if (this.building == null) {
            this.updateColonyReferences();
        }
        return this.building;
    }

    @Override
    public void setBuilding(IBuilding b) {
        this.building = b;
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return this.getBlockState().getBlock().getName();
    }

    @Override
    public IBuildingView getBuildingView() {
        IColonyView c = IColonyManager.getInstance().getColonyView(this.colonyId, (ResourceKey<Level>)this.level.dimension());
        return c == null ? null : c.getBuilding(this.getPosition());
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        Object path;
        String packName;
        super.loadAdditional(compound, provider);
        if (compound.contains(TAG_COLONY)) {
            this.colonyId = compound.getInt(TAG_COLONY);
        }
        if (compound.contains("rotMir", 1)) {
            this.rotationMirror = RotationMirror.values()[compound.getByte("rotMir")];
        }
        if (compound.contains(TAG_STYLE) && !compound.getString(TAG_STYLE).isEmpty()) {
            packName = BlueprintMapping.getStyleMapping(compound.getString(TAG_STYLE));
            if (this.getSchematicName().isEmpty()) {
                path = null;
            } else {
                String level = this.getSchematicName().substring(this.getSchematicName().length() - 1);
                path = BlueprintMapping.getPathMapping(compound.getString(TAG_STYLE), this.getSchematicName().substring(0, this.getSchematicName().length() - 1)) + level + ".blueprint";
            }
        } else {
            packName = compound.getString(TAG_PACK);
            path = compound.getString(TAG_PATH);
        }
        if (packName == null || packName.isEmpty()) {
            ArrayList tags = new ArrayList(this.getPositionedTags().getOrDefault(BlockPos.ZERO, new ArrayList()));
            if (!tags.isEmpty()) {
                tags.remove("deactivated");
                if (!tags.isEmpty()) {
                    packName = BlueprintMapping.getStyleMapping((String)tags.get(0));
                    if (path == null || ((String)path).isEmpty()) {
                        path = BlueprintMapping.getPathMapping((String)tags.get(0), ((AbstractBlockHut)this.getBlockState().getBlock()).getBlueprintName()) + "1.blueprint";
                    }
                }
            } else if (StructurePacks.selectedPack != null) {
                packName = StructurePacks.selectedPack.getName();
            }
        }
        if (path == null || ((String)path).isEmpty() || ((String)path).contains("null")) {
            path = BlueprintMapping.getPathMapping("", ((AbstractBlockHut)this.getBlockState().getBlock()).getBlueprintName()) + "1.blueprint";
        }
        if (!((String)path).endsWith(".blueprint")) {
            path = (String)path + ".blueprint";
        }
        this.packMeta = packName;
        this.path = path;
        if (compound.contains("type")) {
            this.registryName = ResourceLocation.parse((String)compound.getString("type"));
        }
        this.buildingPos = this.worldPosition;
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt(TAG_COLONY, this.colonyId);
        if (this.rotationMirror != null) {
            compound.putByte("rotMir", (byte)this.rotationMirror.ordinal());
        }
        compound.putString(TAG_PACK, this.packMeta == null ? "" : this.packMeta);
        compound.putString(TAG_PATH, this.path == null ? "" : this.path);
        if (this.registryName != null) {
            compound.putString("type", this.registryName.toString());
        }
    }

    @Override
    public void tick() {
        IColony tempColony;
        if (this.combinedInv != null) {
            this.invalidateCapabilities();
            this.combinedInv = null;
        }
        if (!this.getLevel().isClientSide && this.colonyId == 0 && (tempColony = IColonyManager.getInstance().getColonyByPosFromWorld(this.getLevel(), this.getPosition())) != null) {
            this.colonyId = tempColony.getID();
        }
        if (!this.getLevel().isClientSide && this.colonyId != 0 && this.colony == null) {
            this.updateColonyReferences();
        }
        if (this.pendingBlueprintFuture != null && this.pendingBlueprintFuture.isDone()) {
            try {
                this.processBlueprint(this.pendingBlueprintFuture.get());
                this.pendingBlueprintFuture = null;
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isUsableByPlayer(@NotNull Player player) {
        return this.hasAccessPermission(player);
    }

    @Override
    public boolean hasAccessPermission(Player player) {
        return this.building == null || this.building.getColony().getPermissions().hasPermission(player, Action.ACCESS_HUTS);
    }

    @Override
    public void setRotationMirror(RotationMirror rotationMirror) {
        this.rotationMirror = rotationMirror;
    }

    @Override
    public RotationMirror getRotationMirror() {
        if (this.rotationMirror == null) {
            this.calcRotation(StructurePacks.getBlueprint((String)this.packMeta, (String)this.path.replace("0.blueprint", "1.blueprint"), (HolderLookup.Provider)this.level.registryAccess()));
        }
        return this.rotationMirror;
    }

    @Override
    public StructurePackMeta getStructurePack() {
        return StructurePacks.getStructurePack((String)this.packMeta);
    }

    @Override
    public void setStructurePack(StructurePackMeta style) {
        this.packMeta = style.getName();
    }

    @Override
    public void setBlueprintPath(String path) {
        this.path = path;
    }

    public void setPackName(String packName) {
        this.packMeta = packName;
    }

    public String getPackName() {
        return this.packMeta;
    }

    @Override
    public String getBlueprintPath() {
        return this.path;
    }

    @Override
    public ResourceLocation getBuildingName() {
        if (this.registryName != null && !this.registryName.getPath().isEmpty()) {
            return new ResourceLocation(this.registryName.getNamespace(), this.registryName.getPath().replace("home", "residence"));
        }
        return this.getBlockState().getBlock() instanceof AbstractBlockHut ? ((AbstractBlockHut)this.getBlockState().getBlock()).getBuildingEntry().getRegistryName() : null;
    }

    @Override
    public void updateBlockState() {
    }

    @Override
    public IItemHandler getItemHandlerCap(Direction side) {
        if (!this.remove && this.getBuilding() != null) {
            if (this.combinedInv == null) {
                LinkedHashSet<IItemHandlerModifiable> handlers = new LinkedHashSet<IItemHandlerModifiable>();
                Level world = this.colony.getWorld();
                if (world != null) {
                    for (BlockPos pos : this.building.getContainers()) {
                        BlockEntity te;
                        if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos) || pos.equals((Object)this.worldPosition) || (te = world.getBlockEntity(pos)) == null) continue;
                        if (te instanceof AbstractTileEntityRack) {
                            AbstractTileEntityRack rack = (AbstractTileEntityRack)te;
                            handlers.add(rack.getInventory());
                            rack.setBuildingPos(this.getBlockPos());
                            continue;
                        }
                        this.building.removeContainerPosition(pos);
                    }
                }
                handlers.add(this.getInventory());
                this.combinedInv = new CombinedItemHandler(this.building.getSchematicName(), handlers.toArray(new IItemHandlerModifiable[0]));
            }
            return this.combinedInv;
        }
        return super.getItemHandlerCap(side);
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inv, @NotNull Player player) {
        return new ContainerBuildingInventory(id, inv, this.colonyId, this.getBlockPos());
    }

    public void reactivate() {
        Object blueprintPath;
        String packName;
        ArrayList tags = new ArrayList(this.getPositionedTags().get(BlockPos.ZERO));
        tags.remove("deactivated");
        if (tags.isEmpty()) {
            this.pendingBlueprintFuture = StructurePacks.getBlueprintFuture((String)this.packMeta, (String)this.path, (HolderLookup.Provider)this.level.registryAccess());
            return;
        }
        String tagName = (String)tags.get(0);
        if (tagName.contains("/")) {
            String[] split = tagName.split("/");
            packName = split[0];
            blueprintPath = tagName.replace(packName, "");
        } else {
            String level = this.getSchematicName().substring(this.getSchematicName().length() - 1);
            packName = BlueprintMapping.getStyleMapping(tagName);
            blueprintPath = BlueprintMapping.getPathMapping(tagName, this.getSchematicName().substring(0, this.getSchematicName().length() - 1)) + level + ".blueprint";
        }
        if (!StructurePacks.hasPack((String)packName)) {
            this.pendingBlueprintFuture = StructurePacks.getBlueprintFuture((String)this.packMeta, (String)this.path, (HolderLookup.Provider)this.level.registryAccess());
            return;
        }
        this.setStructurePack(StructurePacks.getStructurePack((String)packName));
        this.pendingBlueprintFuture = StructurePacks.getBlueprintFuture((String)packName, (String)blueprintPath, (HolderLookup.Provider)this.level.registryAccess());
    }

    private void processBlueprint(Blueprint blueprint) {
        if (blueprint == null) {
            return;
        }
        this.calcRotation(blueprint);
        BlockInfo info = blueprint.getBlockInfoAsMap().getOrDefault(blueprint.getPrimaryBlockOffset(), null);
        if (info.getTileEntityData() != null) {
            CompoundTag teCompound = info.getTileEntityData().copy();
            CompoundTag tagData = teCompound.getCompound("blueprintDataProvider");
            tagData.putString(TAG_PACK, blueprint.getPackName());
            String location = StructurePacks.getStructurePack((String)blueprint.getPackName()).getSubPath(blueprint.getFilePath().resolve(blueprint.getFileName()));
            tagData.putString("name", location);
            this.readSchematicDataFromNBT(teCompound);
        }
    }

    private void calcRotation(Blueprint blueprint) {
        int worldRotation;
        if (blueprint == null) {
            this.rotationMirror = RotationMirror.NONE;
            return;
        }
        BlockState structureState = blueprint.getBlockState(blueprint.getPrimaryBlockOffset());
        if (structureState == null || !(structureState.getBlock() instanceof AbstractBlockHut) || !(this.level.getBlockState(this.getPosition()).getBlock() instanceof AbstractBlockHut)) {
            this.rotationMirror = RotationMirror.NONE;
            return;
        }
        int structureRotation = ((Direction)structureState.getValue((Property)AbstractBlockHut.FACING)).get2DDataValue();
        int rotation = structureRotation <= (worldRotation = ((Direction)this.level.getBlockState(this.getPosition()).getValue((Property)AbstractBlockHut.FACING)).get2DDataValue()) ? worldRotation - structureRotation : 4 + worldRotation - structureRotation;
        this.rotationMirror = RotationMirror.of((Rotation)Rotation.values()[rotation], (Mirror)(this.rotationMirror == null ? Mirror.NONE : this.rotationMirror.mirror()));
        blueprint.setRotationMirror(this.rotationMirror, this.level);
    }

    public void writeColonyToItemStack(ItemStack stack) {
        new ColonyId(this.getColonyId(), (ResourceKey<Level>)this.getLevel().dimension()).writeToItemStack(stack);
    }
}

