/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.research;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.api.research.factories.ILocalResearchFactory;
import com.minecolonies.api.research.util.ResearchState;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.core.research.LocalResearch;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class LocalResearchFactory
implements ILocalResearchFactory {
    @Override
    @NotNull
    public TypeToken<LocalResearch> getFactoryOutputType() {
        return TypeToken.of(LocalResearch.class);
    }

    @Override
    @NotNull
    public TypeToken<FactoryVoidInput> getFactoryInputType() {
        return TypeConstants.FACTORYVOIDINPUT;
    }

    @Override
    @NotNull
    public ILocalResearch getNewInstance(ResourceLocation id, ResourceLocation branch, int depth) {
        return new LocalResearch(id, branch, depth);
    }

    @Override
    @NotNull
    public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull ILocalResearch research) {
        CompoundTag compound = new CompoundTag();
        compound.putInt("state", research.getState().ordinal());
        compound.putString("id", research.getId().toString());
        compound.putString("branch", research.getBranch().toString());
        compound.putInt("progress", research.getProgress());
        compound.putInt("depth", research.getDepth());
        return compound;
    }

    @Override
    @NotNull
    public ILocalResearch deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
        int state = nbt.getInt("state");
        ResourceLocation id = ResourceLocation.parse((String)nbt.getString("id"));
        ResourceLocation branch = ResourceLocation.parse((String)nbt.getString("branch"));
        int depth = nbt.getInt("depth");
        int progress = nbt.getInt("progress");
        ILocalResearch research = this.getNewInstance(id, branch, depth);
        research.setState(ResearchState.values()[state]);
        research.setProgress(progress);
        return research;
    }

    @Override
    public void serialize(IFactoryController controller, ILocalResearch input, RegistryFriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(input.getState().ordinal());
        packetBuffer.writeUtf(input.getId().toString());
        packetBuffer.writeResourceLocation(input.getBranch());
        packetBuffer.writeInt(input.getProgress());
        packetBuffer.writeInt(input.getDepth());
    }

    @Override
    public ILocalResearch deserialize(IFactoryController controller, RegistryFriendlyByteBuf buffer) throws Throwable {
        int state = buffer.readInt();
        ResourceLocation id = buffer.readResourceLocation();
        ResourceLocation branch = buffer.readResourceLocation();
        int progress = buffer.readInt();
        int depth = buffer.readInt();
        ILocalResearch research = this.getNewInstance(id, branch, depth);
        research.setState(ResearchState.values()[state]);
        research.setProgress(progress);
        return research;
    }

    @Override
    public short getSerializationId() {
        return 29;
    }
}

