/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.recipes;

import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.recipe.ModRecipeTypes;
import com.ldtteam.domumornamentum.recipe.architectscutter.ArchitectsCutterRecipe;
import com.ldtteam.domumornamentum.recipe.architectscutter.ArchitectsCutterRecipeInput;
import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.ModCraftingTypes;
import com.minecolonies.api.crafting.RecipeCraftingType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArchitectsCutterCraftingType
extends RecipeCraftingType<ArchitectsCutterRecipeInput, ArchitectsCutterRecipe> {
    public ArchitectsCutterCraftingType() {
        super(ModCraftingTypes.ARCHITECTS_CUTTER_ID, (RecipeType)ModRecipeTypes.ARCHITECTS_CUTTER.get(), null);
    }

    @Override
    @NotNull
    public List<IGenericRecipe> findRecipes(@NotNull RecipeManager recipeManager, @Nullable Level world) {
        Random rnd = new Random();
        ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>();
        for (RecipeHolder holder : recipeManager.getAllRecipesFor((RecipeType)ModRecipeTypes.ARCHITECTS_CUTTER.get())) {
            ArchitectsCutterRecipe recipe = (ArchitectsCutterRecipe)holder.value();
            Block generatedBlock = (Block)BuiltInRegistries.BLOCK.get(recipe.getBlockName());
            if (!(generatedBlock instanceof IMateriallyTexturedBlock)) continue;
            IMateriallyTexturedBlock materiallyTexturedBlock = (IMateriallyTexturedBlock)generatedBlock;
            ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
            for (IMateriallyTexturedBlockComponent component : materiallyTexturedBlock.getComponents()) {
                HolderSet.Named tag = BuiltInRegistries.BLOCK.getTag(component.getValidSkins()).orElse(null);
                if (tag == null) continue;
                List blocks = tag.stream().map(Holder::value).collect(Collectors.toList());
                Collections.shuffle(blocks, rnd);
                inputs.add(blocks.stream().map(ItemStack::new).collect(Collectors.toList()));
            }
            ItemStack output = recipe.getResultItem((HolderLookup.Provider)world.registryAccess()).copy();
            output.setCount(Math.max(recipe.getCount(), inputs.size()));
            MaterialTextureData.EMPTY.writeToItemStack(output);
            recipes.add(GenericRecipe.builder().withRecipeId(holder.id()).withOutput(output).withInputs(inputs).withGridSize(3).build());
        }
        return recipes;
    }
}

