/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.placementhandlers.main;

import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.placement.StructurePlacementUtils;
import com.ldtteam.structurize.storage.ISurvivalBlueprintHandler;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.advancements.PlaceSupplyTrigger;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.items.component.SupplyData;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.MineColonies;
import java.util.function.Predicate;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class SuppliesHandler
implements ISurvivalBlueprintHandler {
    public static final String ID = "minecolonies:supplies";

    public String getId() {
        return ID;
    }

    public Component getDisplayName() {
        return Component.translatableEscape((String)"com.minecolonies.coremod.supplies.placement", (Object[])new Object[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean canHandle(Blueprint blueprint, ClientLevel clientLevel, Player player, BlockPos blockPos, RotationMirror rotMir) {
        return false;
    }

    public void handle(Blueprint blueprint, String packName, String blueprintPath, boolean clientPack, Level world, Player playerArg, BlockPos blockPos, RotationMirror rotMir) {
        int slot;
        if (clientPack || !StructurePacks.hasPack((String)packName)) {
            MessageUtils.format("com.minecolonies.coremod.structures.nocustomcamps", new Object[0]).sendTo(playerArg);
            SoundUtils.playErrorSound(playerArg, playerArg.blockPosition());
            return;
        }
        ServerPlayer player = (ServerPlayer)playerArg;
        blueprint.setRotationMirror(rotMir, world);
        if (!(player.getStats().getValue(Stats.ITEM_USED.get((Object)ModItems.supplyChest)) <= 0 || ((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).allowInfiniteSupplyChests.get()).booleanValue() || this.isFreeInstantPlacementMH(player) || player.isCreative())) {
            MessageUtils.format("com.minecolonies.coremod.error.supplychestalreadyplaced", new Object[0]).sendTo(new Player[]{player});
            SoundUtils.playErrorSound((Player)player, player.blockPosition());
            return;
        }
        Predicate<ItemStack> searchPredicate = stack -> !stack.isEmpty();
        if (blueprintPath.contains("supplyship")) {
            searchPredicate = searchPredicate.and(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, new ItemStack((ItemLike)ModItems.supplyChest), true, false));
        }
        if (blueprintPath.contains("supplycamp")) {
            searchPredicate = searchPredicate.and(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, new ItemStack((ItemLike)ModItems.supplyCamp), true, false));
        }
        if (this.isFreeInstantPlacementMH(player)) {
            searchPredicate = searchPredicate.and(stack -> SupplyData.readFromItemStack(stack).instantPlacement());
        }
        if ((slot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)new InvWrapper((Container)player.getInventory()), searchPredicate)) != -1 && !ItemStackUtils.isEmpty(player.getInventory().removeItemNoUpdate(slot))) {
            if (player.getStats().getValue(Stats.ITEM_USED.get((Object)ModItems.supplyChest)) < 1) {
                MessageUtils.format("com.minecolonies.coremod.progress.supplies_placed", new Object[0]).sendTo(new Player[]{player});
                player.awardStat(Stats.ITEM_USED.get((Object)ModItems.supplyChest), 1);
                ((PlaceSupplyTrigger)((Object)AdvancementTriggers.PLACE_SUPPLY.get())).trigger(player);
            }
            SoundUtils.playSuccessSound((Player)player, player.blockPosition());
            StructurePlacementUtils.loadAndPlaceStructureWithRotation((Level)player.level(), (Blueprint)blueprint, (BlockPos)blockPos, (RotationMirror)rotMir, (boolean)true, (ServerPlayer)player);
        } else {
            MessageUtils.format("item.supplychestdeployer.missing", new Object[0]).sendTo(new Player[]{player});
        }
    }

    private boolean isFreeInstantPlacementMH(ServerPlayer playerEntity) {
        ItemStack mhItem = playerEntity.getMainHandItem();
        return !ItemStackUtils.isEmpty(mhItem) && SupplyData.readFromItemStack(mhItem).instantPlacement();
    }
}

