/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.placementhandlers;

import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.schematic.BlockSolidSubstitution;
import com.ldtteam.structurize.blocks.schematic.BlockSubstitution;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.ldtteam.structurize.util.BlockUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SolidPlaceholderPlacementHandler
implements IPlacementHandler {
    private BlockState replacement = Blocks.DIRT.defaultBlockState();
    private IPlacementHandler replacementHandler = null;

    public void setReplacement(BlockState state) {
        this.replacement = state;
    }

    public BlockState getReplacement() {
        return this.replacement;
    }

    public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
        return blockState.getBlock() instanceof BlockSolidSubstitution;
    }

    private void searchHandler(Level world, BlockPos pos) {
        if (this.replacementHandler == null) {
            for (IPlacementHandler handler : PlacementHandlers.handlers) {
                if (handler == this || !handler.canHandle(world, pos, this.replacement)) continue;
                this.replacementHandler = handler;
                break;
            }
        }
    }

    public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
        this.searchHandler(world, pos);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (!complete) {
            return this.replacementHandler.getRequiredItems(world, pos, this.replacement, tileEntityData, complete);
        }
        items.add(new ItemStack((ItemLike)blockState.getBlock()));
        return items;
    }

    public IPlacementHandler.ActionProcessingResult handle(Blueprint blueprint, Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos, RotationMirror settings) {
        if (complete) {
            world.setBlock(pos, ((BlockSubstitution)ModBlocks.blockSubstitution.get()).defaultBlockState(), 3);
            return IPlacementHandler.ActionProcessingResult.PASS;
        }
        if (BlockUtils.isAnySolid((BlockState)world.getBlockState(pos))) {
            return IPlacementHandler.ActionProcessingResult.DENY;
        }
        this.searchHandler(world, pos);
        return this.replacementHandler.handle(world, pos, this.replacement, tileEntityData, complete, centerPos, settings);
    }
}

