/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.citizen;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class RestartCitizenMessage
extends AbstractColonyServerMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"restart_citizen", RestartCitizenMessage::new);
    private final int citizenID;

    public RestartCitizenMessage(@NotNull AbstractBuildingView building, int citizenID) {
        super(TYPE, building.getColony());
        this.citizenID = citizenID;
    }

    protected RestartCitizenMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.citizenID = buf.readInt();
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.citizenID);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony) {
        ICitizenData citizen = colony.getCitizenManager().getCivilian(this.citizenID);
        citizen.scheduleRestart(player);
        MessageUtils.format("com.minecolonies.coremod.gui.hiring.restartmessage", citizen.getName()).sendTo(new Player[]{player});
    }
}

