/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building.worker;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import com.minecolonies.core.util.TeleportHelper;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class RecallCitizenMessage
extends AbstractBuildingServerMessage<IBuilding> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"recall_citizen", RecallCitizenMessage::new);

    protected RecallCitizenMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
    }

    public RecallCitizenMessage(IBuildingView building) {
        super(TYPE, building);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, IBuilding building) {
        ArrayList<ICitizenData> citizens = new ArrayList<ICitizenData>(building.getAllAssignedCitizen());
        int i = 0;
        while (i < building.getAllAssignedCitizen().size()) {
            Optional<AbstractEntityCitizen> optionalEntityCitizen = ((ICitizenData)citizens.get(i)).getEntity();
            ICitizenData citizenData = (ICitizenData)citizens.get(i);
            if (!optionalEntityCitizen.isPresent()) {
                if (citizenData == null) {
                    Log.getLogger().warn("Citizen is AWOL and citizenData is null!");
                    return;
                }
                Log.getLogger().warn(String.format("Citizen #%d:%d has gone AWOL, respawning them!", colony.getID(), citizenData.getId()));
                citizenData.setNextRespawnPosition(EntityUtils.getSpawnPoint(colony.getWorld(), building.getPosition()));
                citizenData.updateEntityIfNecessary();
            } else if (optionalEntityCitizen.get().getTicksExisted() == 0) {
                citizenData.getEntity().ifPresent(e -> e.remove(Entity.RemovalReason.DISCARDED));
                citizenData.updateEntityIfNecessary();
            }
            BlockPos loc = building.getPosition();
            if (optionalEntityCitizen.isPresent() && !TeleportHelper.teleportCitizen(optionalEntityCitizen.get(), colony.getWorld(), loc)) {
                MessageUtils.format("com.minecolonies.coremod.workerhuts.recallfail", new Object[0]).sendTo(new Player[]{player});
            }
            ++i;
        }
        return;
    }
}

