/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building.home;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.core.colony.buildings.DefaultBuildingInstance;
import com.minecolonies.core.colony.buildings.modules.AbstractAssignedCitizenModule;
import com.minecolonies.core.colony.buildings.modules.LivingBuildingModule;
import com.minecolonies.core.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class AssignUnassignMessage
extends AbstractBuildingServerMessage<DefaultBuildingInstance> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"assign_unassign", AssignUnassignMessage::new);
    private final boolean assign;
    private final int citizenID;
    private final JobEntry jobEntry;

    public AssignUnassignMessage(@NotNull IBuildingView building, boolean assign, int citizenID, JobEntry entry) {
        super(TYPE, building);
        this.assign = assign;
        this.citizenID = citizenID;
        this.jobEntry = entry;
    }

    protected AssignUnassignMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.assign = buf.readBoolean();
        this.citizenID = buf.readInt();
        this.jobEntry = buf.readBoolean() ? (JobEntry)buf.readById(arg_0 -> IMinecoloniesAPI.getInstance().getJobRegistry().byIdOrThrow(arg_0)) : null;
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.assign);
        buf.writeInt(this.citizenID);
        buf.writeBoolean(this.jobEntry != null);
        if (this.jobEntry != null) {
            buf.writeById(arg_0 -> IMinecoloniesAPI.getInstance().getJobRegistry().getIdOrThrow(arg_0), (Object)this.jobEntry);
        }
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, DefaultBuildingInstance building) {
        ICitizenData citizen = colony.getCitizenManager().getCivilian(this.citizenID);
        AbstractAssignedCitizenModule module = this.jobEntry == null ? (AbstractAssignedCitizenModule)building.getFirstModuleOccurance(LivingBuildingModule.class) : (AbstractAssignedCitizenModule)building.getModuleMatching(WorkerBuildingModule.class, m -> m.getJobEntry() == this.jobEntry);
        if (this.assign && !module.isFull() && !building.equals(citizen.getHomeBuilding())) {
            if (citizen.getHomeBuilding() != null) {
                ((LivingBuildingModule)citizen.getHomeBuilding().getFirstModuleOccurance(LivingBuildingModule.class)).removeCitizen(citizen);
            }
            module.assignCitizen(citizen);
        } else if (module.hasAssignedCitizen(citizen)) {
            module.removeCitizen(citizen);
        }
    }
}

