/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import com.minecolonies.core.tileentities.TileEntityGrave;
import com.minecolonies.core.tileentities.TileEntityRack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenInventoryMessage
extends AbstractColonyServerMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"open_inventory", OpenInventoryMessage::new);
    private final String name;
    private final InventoryType inventoryType;
    private int entityID;
    private BlockPos tePos;

    public OpenInventoryMessage(IColonyView colony, @NotNull String name, int id) {
        super(TYPE, colony);
        this.inventoryType = InventoryType.INVENTORY_CITIZEN;
        this.name = name;
        this.entityID = id;
    }

    public OpenInventoryMessage(IBuildingView building) {
        super(TYPE, building.getColony());
        this.inventoryType = InventoryType.INVENTORY_CHEST;
        this.name = "";
        this.tePos = building.getID();
    }

    protected OpenInventoryMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.inventoryType = InventoryType.values()[buf.readInt()];
        this.name = buf.readUtf(Short.MAX_VALUE);
        switch (this.inventoryType.ordinal()) {
            case 0: {
                this.entityID = buf.readInt();
                break;
            }
            case 1: {
                this.tePos = buf.readBlockPos();
            }
        }
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.inventoryType.ordinal());
        buf.writeUtf(this.name);
        switch (this.inventoryType.ordinal()) {
            case 0: {
                buf.writeInt(this.entityID);
                break;
            }
            case 1: {
                buf.writeBlockPos(this.tePos);
            }
        }
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony) {
        switch (this.inventoryType.ordinal()) {
            case 0: {
                this.doCitizenInventory(player);
                break;
            }
            case 1: {
                this.doHutInventory(player, colony);
                break;
            }
        }
    }

    private void doCitizenInventory(ServerPlayer player) {
        @Nullable AbstractEntityCitizen citizen = (AbstractEntityCitizen)CompatibilityUtils.getWorldFromEntity((Entity)player).getEntity(this.entityID);
        if (citizen != null) {
            if (!StringUtil.isNullOrEmpty((String)this.name)) {
                citizen.getInventoryCitizen().setCustomName(this.name);
            }
            player.openMenu((MenuProvider)citizen, packetBuffer -> packetBuffer.writeVarInt(citizen.getCitizenColonyHandler().getColonyId()).writeVarInt(citizen.getCivilianID()));
        }
    }

    private void doHutInventory(ServerPlayer player, IColony colony) {
        BlockEntity tileEntity = BlockPosUtil.getTileEntity(player.level(), this.tePos);
        if (tileEntity instanceof TileEntityRack || tileEntity instanceof TileEntityGrave) {
            player.openMenu((MenuProvider)tileEntity, packetBuffer -> packetBuffer.writeVarInt(colony.getID()).writeBlockPos(tileEntity.getBlockPos()));
        }
    }

    private static enum InventoryType {
        INVENTORY_CITIZEN,
        INVENTORY_CHEST;

    }
}

