/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.inventory.container.ContainerCrafting;
import com.minecolonies.api.inventory.container.ContainerCraftingBrewingstand;
import com.minecolonies.api.inventory.container.ContainerCraftingFurnace;
import com.minecolonies.api.util.ItemStackUtils;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class TransferRecipeCraftingTeachingMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"transfer_recipe_crafting_teaching", TransferRecipeCraftingTeachingMessage::new);
    private final boolean complete;
    private final Map<Integer, ItemStack> itemStacks;

    public TransferRecipeCraftingTeachingMessage(Map<Integer, ItemStack> itemStacks, boolean complete) {
        super(TYPE);
        this.itemStacks = itemStacks;
        this.complete = complete;
    }

    protected TransferRecipeCraftingTeachingMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.itemStacks = buf.readMap(FriendlyByteBuf::readInt, b -> (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)b)));
        this.complete = buf.readBoolean();
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeMap(this.itemStacks, FriendlyByteBuf::writeInt, (b, v) -> ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)b), v));
        buf.writeBoolean(this.complete);
    }

    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof ContainerCrafting) {
            ContainerCrafting container = (ContainerCrafting)abstractContainerMenu;
            if (this.complete) {
                container.handleSlotClick(container.getSlot(1), this.itemStacks.getOrDefault(0, ItemStackUtils.EMPTY));
                container.handleSlotClick(container.getSlot(2), this.itemStacks.getOrDefault(1, ItemStackUtils.EMPTY));
                container.handleSlotClick(container.getSlot(3), this.itemStacks.getOrDefault(2, ItemStackUtils.EMPTY));
                container.handleSlotClick(container.getSlot(4), this.itemStacks.getOrDefault(3, ItemStackUtils.EMPTY));
                container.handleSlotClick(container.getSlot(5), this.itemStacks.getOrDefault(4, ItemStackUtils.EMPTY));
                container.handleSlotClick(container.getSlot(6), this.itemStacks.getOrDefault(5, ItemStackUtils.EMPTY));
                container.handleSlotClick(container.getSlot(7), this.itemStacks.getOrDefault(6, ItemStackUtils.EMPTY));
                container.handleSlotClick(container.getSlot(8), this.itemStacks.getOrDefault(7, ItemStackUtils.EMPTY));
                container.handleSlotClick(container.getSlot(9), this.itemStacks.getOrDefault(8, ItemStackUtils.EMPTY));
            } else {
                container.handleSlotClick(container.getSlot(1), this.itemStacks.getOrDefault(0, ItemStackUtils.EMPTY));
                container.handleSlotClick(container.getSlot(2), this.itemStacks.getOrDefault(1, ItemStackUtils.EMPTY));
                container.handleSlotClick(container.getSlot(3), this.itemStacks.getOrDefault(3, ItemStackUtils.EMPTY));
                container.handleSlotClick(container.getSlot(4), this.itemStacks.getOrDefault(4, ItemStackUtils.EMPTY));
            }
            container.broadcastChanges();
        } else {
            abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof ContainerCraftingFurnace) {
                ContainerCraftingFurnace container = (ContainerCraftingFurnace)abstractContainerMenu;
                container.setFurnaceInput(this.itemStacks.getOrDefault(0, ItemStack.EMPTY));
            } else {
                abstractContainerMenu = player.containerMenu;
                if (abstractContainerMenu instanceof ContainerCraftingBrewingstand) {
                    ContainerCraftingBrewingstand container = (ContainerCraftingBrewingstand)abstractContainerMenu;
                    container.setInput(this.itemStacks.getOrDefault(0, ItemStack.EMPTY));
                    container.setContainer(this.itemStacks.getOrDefault(1, ItemStack.EMPTY));
                }
            }
        }
    }
}

