/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.items.ItemBannerRallyGuards;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class RemoveFromRallyingListMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"remove_from_rallying_list", RemoveFromRallyingListMessage::new);
    private final ItemStack banner;
    private final BlockPos location;

    public RemoveFromRallyingListMessage(ItemStack banner, BlockPos pos) {
        super(TYPE);
        this.banner = banner;
        this.location = pos;
    }

    protected RemoveFromRallyingListMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.banner = Utils.deserializeCodecMess(buf);
        this.location = buf.readBlockPos();
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        Utils.serializeCodecMess(buf, this.banner);
        buf.writeBlockPos(this.location);
    }

    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player) {
        int slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((Container)player.getInventory()), itemStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, this.banner));
        if (slot == -1) {
            MessageUtils.format("com.minecolonies.coremod.item.bannerrallyguards.gui.error", new Object[0]).sendTo(new Player[]{player});
            return;
        }
        ItemBannerRallyGuards.removeGuardTowerAtLocation(player.getInventory().getItem(slot), this.location);
    }
}

