/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.network.messages.client.OpenCantFoundColonyWarningMessage;
import com.minecolonies.core.network.messages.client.OpenColonyFoundingCovenantMessage;
import com.minecolonies.core.network.messages.client.OpenDeleteAbandonColonyMessage;
import com.minecolonies.core.network.messages.client.OpenReactivateColonyMessage;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class GetColonyInfoMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"get_colony_info", GetColonyInfoMessage::new);
    BlockPos pos;

    public GetColonyInfoMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(type);
        this.pos = buf.readBlockPos();
    }

    public GetColonyInfoMessage(BlockPos pos) {
        super(TYPE);
        this.pos = pos;
    }

    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
    }

    protected void onExecute(IPayloadContext ctxIn, ServerPlayer sender) {
        if (sender == null) {
            return;
        }
        Level world = sender.level();
        if (IColonyManager.getInstance().getColonyByPosFromWorld(world, this.pos) instanceof Colony) {
            MessageUtils.format("com.minecolonies.coremod.gui.nobuilding", new Object[0]).sendTo(new Player[]{sender});
            return;
        }
        IColony iColony = IColonyManager.getInstance().getIColonyByOwner(world, (Player)sender);
        if (iColony instanceof Colony) {
            Colony colony = (Colony)iColony;
            new OpenDeleteAbandonColonyMessage(this.pos, colony.getName(), colony.getCenter(), colony.getID()).sendToPlayer(sender);
            return;
        }
        IColony nextColony = IColonyManager.getInstance().getClosestColony(world, this.pos);
        if (IColonyManager.getInstance().isFarEnoughFromColonies(world, this.pos)) {
            double spawnDistance = Math.sqrt(BlockPosUtil.getDistanceSquared2D(this.pos, world.getSharedSpawnPos()));
            if (spawnDistance < (double)((Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).minDistanceFromWorldSpawn.get()).intValue()) {
                new OpenCantFoundColonyWarningMessage((Component)Component.translatable((String)"com.minecolonies.core.founding.tooclosetospawn", (Object[])new Object[]{(int)((double)((Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).minDistanceFromWorldSpawn.get()).intValue() - spawnDistance)}), this.pos, true).sendToPlayer(sender);
            } else if (spawnDistance > (double)((Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).maxDistanceFromWorldSpawn.get()).intValue()) {
                new OpenCantFoundColonyWarningMessage((Component)Component.translatable((String)"com.minecolonies.core.founding.toofarfromspawn", (Object[])new Object[]{(int)(spawnDistance - (double)((Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).maxDistanceFromWorldSpawn.get()).intValue())}), this.pos, true).sendToPlayer(sender);
            } else {
                TileEntityColonyBuilding townhall;
                BlockEntity blockEntity = world.getBlockEntity(this.pos);
                if (blockEntity instanceof TileEntityColonyBuilding && (townhall = (TileEntityColonyBuilding)blockEntity).getPositionedTags().containsKey(BlockPos.ZERO) && townhall.getPositionedTags().get(BlockPos.ZERO).contains("deactivated")) {
                    new OpenReactivateColonyMessage(nextColony == null ? "" : nextColony.getName(), nextColony == null ? Integer.MAX_VALUE : (int)BlockPosUtil.getDistance(nextColony.getCenter(), this.pos) - ((Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).initialColonySize.get() << 4), this.pos).sendToPlayer(sender);
                } else {
                    new OpenColonyFoundingCovenantMessage(nextColony == null ? "" : nextColony.getName(), nextColony == null ? Integer.MAX_VALUE : (int)BlockPosUtil.getDistance(nextColony.getCenter(), this.pos) - ((Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).initialColonySize.get() << 4), this.pos).sendToPlayer(sender);
                }
            }
        } else {
            if (nextColony == null) {
                return;
            }
            int blockRange = Math.max((Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).minColonyDistance.get(), (Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).initialColonySize.get()) << 4;
            int distance = (int)BlockPosUtil.getDistance(this.pos, nextColony.getCenter());
            new OpenCantFoundColonyWarningMessage((Component)Component.translatable((String)"com.minecolonies.core.founding.tooclosetocolony", (Object[])new Object[]{Math.max(100, blockRange - distance)}), this.pos, false).sendToPlayer(sender);
        }
    }
}

