/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client.colony;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.entity.citizen.AbstractCivilianEntity;
import com.minecolonies.api.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PlaySoundForCitizenMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"play_sound_for_citizen", PlaySoundForCitizenMessage::new);
    private final int entityid;
    private final SoundEvent soundEvent;
    private final SoundSource soundSource;
    private final BlockPos pos;
    private final ResourceKey<Level> dimensionID;
    private final float volume;
    private final float pitch;
    private final int length;
    private final int repetitions;

    public PlaySoundForCitizenMessage(int entityID, SoundEvent event, BlockPos pos, Level world) {
        this(entityID, event, SoundSource.NEUTRAL, pos, world, 0.5f, 1.0f, 1, 1);
    }

    public PlaySoundForCitizenMessage(int entityID, SoundEvent event, SoundSource soundSource, BlockPos pos, Level world) {
        this(entityID, event, soundSource, pos, world, 0.5f, 1.0f, 1, 1);
    }

    public PlaySoundForCitizenMessage(int entityID, SoundEvent event, SoundSource soundSource, BlockPos pos, Level world, int length, int repetitions) {
        this(entityID, event, soundSource, pos, world, 0.5f, 1.0f, length, repetitions);
    }

    public PlaySoundForCitizenMessage(int entityID, SoundEvent event, SoundSource soundSource, BlockPos pos, Level world, float volume, float pitch, int length, int repetitions) {
        super(TYPE);
        this.entityid = entityID;
        this.soundEvent = event;
        this.soundSource = soundSource;
        this.pos = pos;
        this.dimensionID = world.dimension();
        this.volume = volume;
        this.pitch = pitch;
        this.length = length;
        this.repetitions = repetitions;
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeResourceLocation(this.soundEvent.getLocation());
        buf.writeInt(this.soundSource.ordinal());
        buf.writeBlockPos(this.pos);
        buf.writeUtf(this.dimensionID.location().toString());
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
        buf.writeInt(this.length);
        buf.writeInt(this.repetitions);
        buf.writeInt(this.entityid);
    }

    public PlaySoundForCitizenMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.soundEvent = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(buf.readResourceLocation());
        this.soundSource = SoundSource.values()[buf.readInt()];
        this.pos = buf.readBlockPos();
        this.dimensionID = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)buf.readUtf(Short.MAX_VALUE)));
        this.volume = buf.readFloat();
        this.pitch = buf.readFloat();
        this.length = buf.readInt();
        this.repetitions = buf.readInt();
        this.entityid = buf.readInt();
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        Entity entity = player.level().getEntity(this.entityid);
        if (entity instanceof AbstractCivilianEntity) {
            AbstractCivilianEntity citizen = (AbstractCivilianEntity)entity;
            SoundManager.addToQueue(citizen.getUUID(), this.soundEvent, this.soundSource, this.repetitions, this.length, this.pos, this.volume, this.pitch);
        }
    }
}

