/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client.colony;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PlayMusicAtPosMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"play_music_at_pos", PlayMusicAtPosMessage::new);
    private final SoundEvent soundEvent;
    private final BlockPos pos;
    private final ResourceKey<Level> dimensionID;
    private final float volume;
    private final float pitch;

    public PlayMusicAtPosMessage(SoundEvent event, BlockPos pos, Level world, float volume, float pitch) {
        super(TYPE);
        this.soundEvent = event;
        this.pos = pos;
        this.dimensionID = world.dimension();
        this.volume = volume;
        this.pitch = pitch;
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeResourceLocation(BuiltInRegistries.SOUND_EVENT.getKey((Object)this.soundEvent));
        buf.writeBlockPos(this.pos);
        buf.writeUtf(this.dimensionID.location().toString());
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
    }

    protected PlayMusicAtPosMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.soundEvent = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(buf.readResourceLocation());
        this.pos = buf.readBlockPos();
        this.dimensionID = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)buf.readUtf(Short.MAX_VALUE)));
        this.volume = buf.readFloat();
        this.pitch = buf.readFloat();
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        if (player.level().dimension() == this.dimensionID) {
            player.level().playSound(player, (double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ(), this.soundEvent, SoundSource.AMBIENT, this.volume, this.pitch);
        }
    }
}

