/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client.colony;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ColonyViewBuildingViewMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"colony_view_building_view", ColonyViewBuildingViewMessage::new);
    private final int colonyId;
    private final BlockPos buildingId;
    private final RegistryFriendlyByteBuf buildingData;
    private final ResourceKey<Level> dimension;

    public ColonyViewBuildingViewMessage(@NotNull IBuilding building) {
        this(building, true);
    }

    public ColonyViewBuildingViewMessage(@NotNull IBuilding building, boolean fullSync) {
        super(TYPE);
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.buildingData = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(Unpooled.buffer()), building.getColony().getWorld().registryAccess());
        building.serializeToView(this.buildingData, fullSync);
        this.dimension = building.getColony().getDimension();
    }

    protected ColonyViewBuildingViewMessage(@NotNull RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.colonyId = buf.readInt();
        this.buildingId = buf.readBlockPos();
        this.dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)buf.readUtf(Short.MAX_VALUE)));
        this.buildingData = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])buf.readByteArray())), buf.registryAccess());
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        this.buildingData.resetReaderIndex();
        buf.writeInt(this.colonyId);
        buf.writeBlockPos(this.buildingId);
        buf.writeUtf(this.dimension.location().toString());
        buf.writeByteArray(this.buildingData.array());
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        IColonyManager.getInstance().handleColonyBuildingViewMessage(this.colonyId, this.buildingId, this.buildingData, this.dimension);
    }
}

