/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client.colony;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildingextensions.IBuildingExtension;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.colony.buildingextensions.registry.BuildingExtensionDataManager;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ColonyViewBuildingExtensionsUpdateMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"colony_view_building_extensions_update", ColonyViewBuildingExtensionsUpdateMessage::new);
    private final int colonyId;
    private final ResourceKey<Level> dimension;
    private final Map<IBuildingExtension, IBuildingExtension> extensions;

    public ColonyViewBuildingExtensionsUpdateMessage(@NotNull IColony colony, @NotNull Collection<IBuildingExtension> extensions) {
        super(TYPE);
        this.colonyId = colony.getID();
        this.dimension = colony.getDimension();
        this.extensions = new HashMap<IBuildingExtension, IBuildingExtension>();
        extensions.forEach(extension -> this.extensions.put((IBuildingExtension)extension, (IBuildingExtension)extension));
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeUtf(this.dimension.location().toString());
        buf.writeInt(this.extensions.size());
        for (IBuildingExtension extension : this.extensions.keySet()) {
            RegistryFriendlyByteBuf extensionBuffer = BuildingExtensionDataManager.extensionToBuffer(extension, buf.registryAccess());
            extensionBuffer.resetReaderIndex();
            buf.writeByteArray(extensionBuffer.array());
        }
    }

    protected ColonyViewBuildingExtensionsUpdateMessage(@NotNull RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.colonyId = buf.readInt();
        this.dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)buf.readUtf(Short.MAX_VALUE)));
        this.extensions = new HashMap<IBuildingExtension, IBuildingExtension>();
        int extensionCount = buf.readInt();
        for (int i = 0; i < extensionCount; ++i) {
            IBuildingExtension extension = BuildingExtensionDataManager.bufferToExtension(new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])buf.readByteArray()), buf.registryAccess()));
            this.extensions.put(extension, extension);
        }
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        IColonyView view = IColonyManager.getInstance().getColonyView(this.colonyId, this.dimension);
        if (view != null) {
            HashSet<IBuildingExtension> updatedExtensions = new HashSet<IBuildingExtension>();
            view.getBuildingExtensions(extension -> true).forEach(existingExtension -> {
                if (this.extensions.containsKey(existingExtension)) {
                    RegistryFriendlyByteBuf copyBuffer = new RegistryFriendlyByteBuf(Unpooled.buffer(), player.level().registryAccess());
                    this.extensions.get(existingExtension).serialize(copyBuffer);
                    existingExtension.deserialize(copyBuffer);
                    updatedExtensions.add((IBuildingExtension)existingExtension);
                }
            });
            updatedExtensions.addAll(this.extensions.keySet());
            view.handleColonyBuildingExtensionsViewUpdateMessage(updatedExtensions);
        } else {
            Log.getLogger().error("Colony view does not exist for ID #{}", (Object)this.colonyId);
        }
    }
}

