/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client.colony;

import com.ldtteam.common.network.AbstractPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.core.client.gui.map.WindowColonyMap;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ColonyListMessage
extends AbstractPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forBothSides((String)"minecolonies", (String)"colony_list", ColonyListMessage::new);
    private final List<IColony> colonies;
    private final List<ColonyInfo> colonyInfo;

    public ColonyListMessage() {
        this(Collections.emptyList());
    }

    public ColonyListMessage(List<IColony> colonies) {
        super(TYPE);
        this.colonies = colonies;
        this.colonyInfo = null;
    }

    protected ColonyListMessage(@NotNull RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.colonies = null;
        this.colonyInfo = buf.readList(b -> {
            ColonyInfo info = new ColonyInfo(b.readInt());
            info.center = b.readBlockPos();
            info.name = b.readUtf(Short.MAX_VALUE);
            info.citizencount = b.readInt();
            info.owner = b.readUtf(Short.MAX_VALUE);
            return info;
        });
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeCollection(this.colonies, (b, colony) -> {
            b.writeInt(colony.getID());
            b.writeBlockPos(colony.getCenter());
            b.writeUtf(colony.getName());
            b.writeInt(colony.getCitizenManager().getCurrentCitizenCount());
            b.writeUtf(colony.getPermissions().getOwnerName());
        });
    }

    protected void onClientExecute(IPayloadContext context, Player player) {
        WindowColonyMap.setColonies(this.colonyInfo);
    }

    protected void onServerExecute(IPayloadContext context, ServerPlayer player) {
        new ColonyListMessage(IColonyManager.getInstance().getColonies(player.level())).sendToPlayer(player);
    }

    public static class ColonyInfo {
        private final int id;
        private BlockPos center;
        private String name;
        private int citizencount;
        private String owner;

        public ColonyInfo(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public BlockPos getCenter() {
            return this.center;
        }

        public String getName() {
            return this.name;
        }

        public int getCitizencount() {
            return this.citizencount;
        }

        public String getOwner() {
            return this.owner;
        }
    }
}

