/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class CircleParticleEffectMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"circle_particle_effect", CircleParticleEffectMessage::new);
    private static final Random RAND = new Random();
    private final SimpleParticleType type;
    private final double posX;
    private final double posY;
    private final double posZ;
    private final int stage;

    public CircleParticleEffectMessage(Vec3 pos, SimpleParticleType type, int stage) {
        super(TYPE);
        this.posX = pos.x;
        this.posY = pos.y - 0.5;
        this.posZ = pos.z;
        this.stage = stage;
        this.type = type;
    }

    public CircleParticleEffectMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.stage = buf.readInt();
        this.type = (SimpleParticleType)BuiltInRegistries.PARTICLE_TYPE.get(buf.readResourceLocation());
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeInt(this.stage);
        buf.writeResourceLocation(BuiltInRegistries.PARTICLE_TYPE.getKey((Object)this.type));
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        double x = 1.0 * Math.cos((double)this.stage * 45.0) + this.posX;
        double z = 1.0 * Math.sin((double)this.stage * 45.0) + this.posZ;
        for (int i = 0; i < 5; ++i) {
            Vec3 randomPos = new Vec3(RAND.nextDouble() * 0.1 + 0.1, RAND.nextDouble() * 0.1 + 0.1, RAND.nextDouble() * 0.1 + 0.1);
            Vec3 randomOffset = new Vec3((RAND.nextDouble() - 0.5) * 0.1, (RAND.nextDouble() - 0.5) * 0.1, (RAND.nextDouble() - 0.5) * 0.1);
            player.level().addParticle((ParticleOptions)this.type, x + randomOffset.x, this.posY + randomOffset.y, z + randomOffset.z, randomPos.x, randomPos.y + 0.05, randomPos.z);
        }
    }
}

