/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.items.AbstractItemScroll;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ItemScrollHighlight
extends AbstractItemScroll {
    public ItemScrollHighlight(Item.Properties properties) {
        super("scroll_highlight", properties);
    }

    @Override
    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        if (ctx.getLevel().isClientSide || ctx.getPlayer() == null || !ctx.getPlayer().isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        BlockEntity te = ctx.getLevel().getBlockEntity(ctx.getClickedPos());
        if (te instanceof TileEntityColonyBuilding) {
            ctx.getItemInHand().shrink(1);
            if (ctx.getLevel().random.nextInt(10) == 0) {
                ctx.getPlayer().displayClientMessage((Component)Component.translatableEscape((String)("minecolonies.scroll.failed" + (ctx.getLevel().random.nextInt(10) + 1)), (Object[])new Object[0]).setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)), true);
                ctx.getPlayer().addEffect(new MobEffectInstance(MobEffects.GLOWING, 6000));
                SoundUtils.playSoundForPlayer((ServerPlayer)ctx.getPlayer(), SoundEvents.ENDER_CHEST_OPEN, 0.3f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            TileEntityColonyBuilding building = (TileEntityColonyBuilding)te;
            Set<ICitizenData> citizens = building.getColony().getBuildingManager().getBuilding(ctx.getClickedPos()).getAllAssignedCitizen();
            for (ICitizenData citizenData : citizens) {
                if (!citizenData.getEntity().isPresent()) continue;
                citizenData.getEntity().get().addEffect(new MobEffectInstance(MobEffects.GLOWING, 2400));
                citizenData.getEntity().get().addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 2400));
            }
            SoundUtils.playSoundForPlayer((ServerPlayer)ctx.getPlayer(), SoundEvents.PLAYER_LEVELUP, 0.3f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected boolean needsColony() {
        return false;
    }

    @Override
    protected ItemStack onItemUseSuccess(ItemStack itemStack, Level world, ServerPlayer player) {
        return itemStack;
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext ctx, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        MutableComponent guiHint = Component.translatableEscape((String)"item.minecolonies.scroll_highlight.tip", (Object[])new Object[0]);
        guiHint.setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GREEN));
        tooltip.add((Component)guiHint);
    }
}

