/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.items.component.BuildingId;
import com.minecolonies.api.items.component.ModDataComponents;
import com.minecolonies.api.items.component.PatrolTarget;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.items.AbstractItemMinecolonies;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemScepterGuard
extends AbstractItemMinecolonies {
    public ItemScepterGuard(Item.Properties properties) {
        super("scepterguard", properties.stacksTo(1).durability(2).component(ModDataComponents.PATROL_TARGET, (Object)PatrolTarget.EMPTY));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        if (ctx.getLevel().isClientSide) {
            return InteractionResult.FAIL;
        }
        ItemStack scepter = ctx.getPlayer().getItemInHand(ctx.getHand());
        PatrolTarget lastPosComp = PatrolTarget.readFromItemStack(scepter);
        if (lastPosComp.pos().equals((Object)ctx.getClickedPos())) {
            ctx.getPlayer().getInventory().removeItemNoUpdate(ctx.getPlayer().getInventory().selected);
            MessageUtils.format("com.minecolonies.coremod.job.guard.tooldoubleclick", new Object[0]).sendTo(ctx.getPlayer());
            return InteractionResult.FAIL;
        }
        return ItemScepterGuard.handleItemUsage(ctx.getLevel(), ctx.getClickedPos(), scepter, ctx.getPlayer());
    }

    @NotNull
    private static InteractionResult handleItemUsage(Level worldIn, BlockPos pos, ItemStack stack, Player playerIn) {
        IBuilding iBuilding = BuildingId.readBuildingFromItemStack(stack);
        if (!(iBuilding instanceof IGuardBuilding)) {
            return InteractionResult.FAIL;
        }
        IGuardBuilding tower = (IGuardBuilding)iBuilding;
        if (BlockPosUtil.getDistance2D(pos, tower.getID()) > (long)tower.getPatrolDistance()) {
            MessageUtils.format("com.minecolonies.coremod.job.guard.toolclickguardtoofar", new Object[0]).sendTo(playerIn);
            return InteractionResult.FAIL;
        }
        if (tower.getSetting(AbstractBuildingGuards.GUARD_TASK).getValue().equals("com.minecolonies.core.guard.setting.guard")) {
            MessageUtils.format("com.minecolonies.coremod.job.guard.toolclickguard", pos.toShortString()).sendTo(playerIn);
            tower.setGuardPos(pos);
            playerIn.getInventory().removeItemNoUpdate(playerIn.getInventory().selected);
        } else {
            if (!PatrolTarget.readFromItemStack(stack).hasPos()) {
                tower.resetPatrolTargets();
            }
            tower.addPatrolTarget(pos);
            MessageUtils.format("com.minecolonies.coremod.job.guard.toolclickpatrol", pos.toShortString()).sendTo(playerIn);
        }
        new PatrolTarget(pos).writeToItemStack(stack);
        return InteractionResult.SUCCESS;
    }
}

