/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation.defaults;

import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.loot.GenerateSupplyLoot;
import com.minecolonies.core.blocks.MinecoloniesCropBlock;
import com.minecolonies.core.generation.defaults.DefaultCropsLootProvider;
import com.minecolonies.core.generation.defaults.DefaultSupplyLootProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.loot.AddTableLootModifier;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;
import org.jetbrains.annotations.NotNull;

public class DefaultLootModifiersProvider
extends GlobalLootModifierProvider {
    public DefaultLootModifiersProvider(@NotNull PackOutput output, @NotNull CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, "minecolonies");
    }

    protected void start() {
        this.addCrops();
        this.addSupplies();
    }

    private void addCrops() {
        HashSet<ResourceKey> cropSources = new HashSet<ResourceKey>();
        for (MinecoloniesCropBlock crop : ModBlocks.getCrops()) {
            for (Block source : crop.getDroppedFrom()) {
                cropSources.add(source.getLootTable());
            }
        }
        for (ResourceKey source : cropSources) {
            ResourceKey<LootTable> cropTable = DefaultCropsLootProvider.getCropSourceLootTable(source.location());
            this.add(cropTable.location().getPath(), (IGlobalLootModifier)new AddTableLootModifier(new LootItemCondition[]{DefaultLootModifiersProvider.forLootTable((ResourceKey<LootTable>)source).build()}, cropTable), new ICondition[]{new ModLoadedCondition("minecolonies")});
        }
        this.add(DefaultCropsLootProvider.DUNGEON_CROPS.location().getPath(), (IGlobalLootModifier)new AddTableLootModifier(new LootItemCondition[]{DefaultLootModifiersProvider.forLootTable((ResourceKey<LootTable>)BuiltInLootTables.SIMPLE_DUNGEON).build()}, DefaultCropsLootProvider.DUNGEON_CROPS), new ICondition[0]);
    }

    private void addSupplies() {
        List<ResourceKey<LootTable>> campTables = List.of(BuiltInLootTables.SPAWN_BONUS_CHEST, BuiltInLootTables.SIMPLE_DUNGEON, BuiltInLootTables.VILLAGE_CARTOGRAPHER, BuiltInLootTables.VILLAGE_MASON, BuiltInLootTables.VILLAGE_DESERT_HOUSE, BuiltInLootTables.VILLAGE_PLAINS_HOUSE, BuiltInLootTables.VILLAGE_TAIGA_HOUSE, BuiltInLootTables.VILLAGE_SNOWY_HOUSE, BuiltInLootTables.VILLAGE_SAVANNA_HOUSE, BuiltInLootTables.ABANDONED_MINESHAFT, BuiltInLootTables.STRONGHOLD_LIBRARY, BuiltInLootTables.STRONGHOLD_CROSSING, BuiltInLootTables.STRONGHOLD_CORRIDOR, BuiltInLootTables.DESERT_PYRAMID, BuiltInLootTables.JUNGLE_TEMPLE, BuiltInLootTables.IGLOO_CHEST, BuiltInLootTables.WOODLAND_MANSION, BuiltInLootTables.PILLAGER_OUTPOST);
        List<ResourceKey<LootTable>> shipTables = List.of(BuiltInLootTables.UNDERWATER_RUIN_SMALL, BuiltInLootTables.UNDERWATER_RUIN_BIG, BuiltInLootTables.BURIED_TREASURE, BuiltInLootTables.SHIPWRECK_MAP, BuiltInLootTables.SHIPWRECK_SUPPLY, BuiltInLootTables.SHIPWRECK_TREASURE, BuiltInLootTables.VILLAGE_FISHER, BuiltInLootTables.VILLAGE_ARMORER, BuiltInLootTables.VILLAGE_TEMPLE);
        this.add("supplycamp_loot", (IGlobalLootModifier)new AddTableLootModifier(new LootItemCondition[]{GenerateSupplyLoot.when().build(), DefaultLootModifiersProvider.forLootTables(campTables).build()}, ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)DefaultSupplyLootProvider.SUPPLY_CAMP_LT)), new ICondition[0]);
        this.add("supplyship_loot", (IGlobalLootModifier)new AddTableLootModifier(new LootItemCondition[]{GenerateSupplyLoot.when().build(), DefaultLootModifiersProvider.forLootTables(shipTables).build()}, ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)DefaultSupplyLootProvider.SUPPLY_SHIP_LT)), new ICondition[0]);
    }

    private static LootItemCondition.Builder forLootTable(@NotNull ResourceKey<LootTable> table) {
        return LootTableIdCondition.builder((ResourceLocation)table.location());
    }

    private static LootItemCondition.Builder forLootTables(@NotNull Collection<ResourceKey<LootTable>> tables) {
        return AnyOfCondition.anyOf((LootItemCondition.Builder[])((LootItemCondition.Builder[])tables.stream().map(t -> LootTableIdCondition.builder((ResourceLocation)t.location())).toArray(LootItemCondition.Builder[]::new)));
    }
}

