/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation.defaults;

import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.loot.ModLootConditions;
import com.minecolonies.core.blocks.BlockMinecoloniesRack;
import com.minecolonies.core.blocks.MinecoloniesCropBlock;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetBannerPatternFunction;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class DefaultBlockLootTableProvider
extends BlockLootSubProvider {
    public DefaultBlockLootTableProvider(@NotNull HolderLookup.Provider provider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
    }

    public void generate() {
        HolderLookup.RegistryLookup enchantments = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        this.saveBlocks(Arrays.asList(ModBlocks.getHuts()));
        this.saveBlock(ModBlocks.blockHutWareHouse);
        this.saveBlock(ModBlocks.blockStash);
        this.saveBlock(ModBlocks.blockRack);
        this.saveBlock(ModBlocks.blockWayPoint);
        this.saveBlock((Block)ModBlocks.blockBarrel);
        this.saveBlock(ModBlocks.blockScarecrow);
        this.saveBlock((Block)ModBlocks.blockPlantationField);
        this.saveBlock((Block)ModBlocks.blockColonyBanner);
        this.saveBlock((Block)ModBlocks.blockColonyWallBanner);
        this.saveBlock((Block)ModBlocks.blockIronGate);
        this.saveBlock((Block)ModBlocks.blockWoodenGate);
        this.saveBlock(ModBlocks.blockCompostedDirt, lootPool -> lootPool.add((LootPoolEntryContainer.Builder)AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[0]).otherwise(LootItem.lootTableItem(ModBlocks.blockCompostedDirt).when(ModLootConditions.hasSilkTouch((HolderLookup.RegistryLookup<Enchantment>)enchantments))).otherwise(LootItem.lootTableItem((ItemLike)Blocks.DIRT).when(ExplosionCondition.survivesExplosion()))));
        this.saveBlock(ModBlocks.farmland, lootPool -> lootPool.add((LootPoolEntryContainer.Builder)AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[0]).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Blocks.DIRT))));
        this.saveBlock(ModBlocks.floodedFarmland, lootPool -> lootPool.add((LootPoolEntryContainer.Builder)AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[0]).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Blocks.DIRT))));
        for (MinecoloniesCropBlock block : ModBlocks.getCrops()) {
            LootItemBlockStatePropertyCondition.Builder cropCondition = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CropBlock.AGE, 6));
            this.saveBlock(block, lootPool -> lootPool.add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block.asItem()).when((LootItemCondition.Builder)cropCondition)).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)enchantments.getOrThrow(Enchantments.FORTUNE), (float)0.5714286f, (int)3)).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block.asItem()))));
        }
    }

    private <T extends Block> void saveBlocks(@NotNull List<T> blocks) {
        for (Block block : blocks) {
            this.saveBlock(block);
        }
    }

    private void saveBlock(@NotNull Block block) {
        LootPoolSingletonContainer.Builder item = LootItem.lootTableItem((ItemLike)block);
        if (block instanceof AbstractBlockHut || block instanceof BlockMinecoloniesRack) {
            item.apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY));
        }
        this.saveBlock(block, lootPool -> lootPool.add((LootPoolEntryContainer.Builder)item).when(ExplosionCondition.survivesExplosion()));
    }

    private void saveBlock(@NotNull Block block, Consumer<LootPool.Builder> lootPoolConfigurer) {
        LootPool.Builder lootPoolbuilder = LootPool.lootPool();
        lootPoolConfigurer.accept(lootPoolbuilder);
        this.add(block, LootTable.lootTable().withPool(lootPoolbuilder));
    }

    private void saveBannerBlock(@NotNull Block block) {
        this.add(block, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block)).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).apply((LootItemFunction.Builder)SetBannerPatternFunction.setBannerPattern((boolean)false)).when(ExplosionCondition.survivesExplosion())));
    }

    protected Iterable<Block> getKnownBlocks() {
        return Stream.concat(Arrays.stream(ModBlocks.getCrops()), Stream.concat(Arrays.stream(ModBlocks.getHuts()), Stream.of(new Block[]{ModBlocks.blockHutWareHouse, ModBlocks.blockStash, ModBlocks.blockRack, ModBlocks.blockWayPoint, ModBlocks.blockBarrel, ModBlocks.blockScarecrow, ModBlocks.blockPlantationField, ModBlocks.blockColonyBanner, ModBlocks.blockColonyWallBanner, ModBlocks.blockIronGate, ModBlocks.blockWoodenGate, ModBlocks.blockCompostedDirt, ModBlocks.floodedFarmland, ModBlocks.farmland})).map(Block.class::cast)).toList();
    }
}

