/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.event;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.core.datalistener.CitizenNameListener;
import com.minecolonies.core.datalistener.CrafterRecipeListener;
import com.minecolonies.core.datalistener.CustomVisitorListener;
import com.minecolonies.core.datalistener.DiseasesListener;
import com.minecolonies.core.datalistener.ItemNbtListener;
import com.minecolonies.core.datalistener.QuestJsonListener;
import com.minecolonies.core.datalistener.RecruitmentItemsListener;
import com.minecolonies.core.datalistener.ResearchListener;
import com.minecolonies.core.datalistener.StudyItemListener;
import com.minecolonies.core.entity.pathfinding.Pathfinding;
import com.minecolonies.core.event.DataPackSyncEventHandler;
import com.minecolonies.core.util.BackUpHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.jetbrains.annotations.NotNull;

public class FMLEventHandler {
    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Pre event) {
        IColonyManager.getInstance().onServerTick(event);
        DataPackSyncEventHandler.ServerEvents.load(event.getServer());
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        IColonyManager.getInstance().onClientTick(event);
    }

    @SubscribeEvent
    public static void onPlayerLogin(@NotNull PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            IColonyManager.getInstance().getIColonyByOwner(event.getEntity().level(), event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onAddReloadListenerEvent(@NotNull AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new CrafterRecipeListener());
        event.addListener((PreparableReloadListener)new ResearchListener());
        event.addListener((PreparableReloadListener)new CustomVisitorListener());
        event.addListener((PreparableReloadListener)new CitizenNameListener());
        event.addListener((PreparableReloadListener)new QuestJsonListener());
        event.addListener((PreparableReloadListener)new ItemNbtListener());
        event.addListener((PreparableReloadListener)new StudyItemListener());
        event.addListener((PreparableReloadListener)new DiseasesListener());
        event.addListener((PreparableReloadListener)new RecruitmentItemsListener());
    }

    @SubscribeEvent
    public static void onServerStarted(@NotNull ServerStartedEvent event) {
        BackUpHelper.loadMissingColonies();
    }

    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Pre event) {
        IColonyManager.getInstance().onWorldTick(event);
    }

    @SubscribeEvent
    public static void onServerAboutToStart(@NotNull ServerAboutToStartEvent event) {
        IColonyManager.getInstance().getRecipeManager().reset();
    }

    @SubscribeEvent
    public static void onServerStopped(@NotNull ServerStoppingEvent event) {
        Pathfinding.shutdown();
        DataPackSyncEventHandler.ServerEvents.reset();
    }
}

