/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.world;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public class CachingBlockLookup
implements BlockGetter {
    private static final int SIZE = 5;
    private static final int MIDDLEOFFSET = 2;
    private int centerX;
    private int centerY;
    private int centerZ;
    private final LevelReader world;
    private final BlockPos.MutableBlockPos temp = new BlockPos.MutableBlockPos();
    private BlockState[] states = new BlockState[125];
    private BlockState[] exchange = new BlockState[125];
    private ChunkAccess chunk = null;

    public CachingBlockLookup(BlockPos center, LevelReader world) {
        this.centerX = center.getX() + 2;
        this.centerY = center.getY() + 2;
        this.centerZ = center.getZ() + 2;
        this.world = world;
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos p_45570_) {
        return null;
    }

    public BlockState getBlockState(BlockPos pos) {
        return this.getBlockState(pos.getX(), pos.getY(), pos.getZ());
    }

    public FluidState getFluidState(BlockPos pos) {
        return this.getBlockState(pos).getFluidState();
    }

    public BlockState getBlockState(int x, int y, int z) {
        int xPos = this.centerX - x;
        int yPos = this.centerY - y;
        int zPos = this.centerZ - z;
        if (xPos < 0 || xPos >= 5 || yPos < 0 || yPos >= 5 || zPos < 0 || zPos >= 5) {
            return this.world.getBlockState((BlockPos)this.temp.set(x, y, z));
        }
        int index = xPos + yPos * 5 + zPos * 5 * 5;
        BlockState state = this.states[index];
        if (state == null) {
            if (this.chunk == null || this.chunk.getPos().x != x >> 4 || this.chunk.getPos().z != z >> 4) {
                this.chunk = this.world.getChunk(x >> 4, z >> 4, ChunkStatus.FULL, false);
            }
            state = this.chunk != null ? this.chunk.getBlockState((BlockPos)this.temp.set(x, y, z)) : this.world.getBlockState((BlockPos)this.temp.set(x, y, z));
            this.states[index] = state;
        }
        return state;
    }

    public void resetToNextPos(int x, int y, int z) {
        int xDiff = x + 2 - this.centerX;
        int yDiff = y + 2 - this.centerY;
        int zDiff = z + 2 - this.centerZ;
        if (Math.abs(xDiff) >= 5 || Math.abs(yDiff) >= 5 || Math.abs(zDiff) >= 5) {
            for (int i = 0; i < this.states.length; ++i) {
                this.states[i] = null;
            }
        } else {
            for (int i = 0; i < this.states.length; ++i) {
                BlockState state = this.states[i];
                if (state == null) continue;
                this.states[i] = null;
                int zPos = i / 25;
                int yPos = (i - zPos * 5 * 5) / 5;
                int xPos = i - zPos * 5 * 5 - yPos * 5;
                if ((xPos += xDiff) < 0 || xPos >= 5 || (yPos += yDiff) < 0 || yPos >= 5 || (zPos += zDiff) < 0 || zPos >= 5) continue;
                int newIndex = xPos + yPos * 5 + zPos * 5 * 5;
                this.exchange[newIndex] = state;
            }
            BlockState[] temp = this.states;
            this.states = this.exchange;
            this.exchange = temp;
        }
        this.centerX = x + 2;
        this.centerY = y + 2;
        this.centerZ = z + 2;
    }

    public int getHeight() {
        return this.world.getHeight();
    }

    public int getMinBuildHeight() {
        return this.world.getMinBuildHeight();
    }
}

