/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.proxy;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.Vec2i;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.colony.buildings.modules.MinerLevelManagementModule;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.colony.jobs.JobMiner;
import com.minecolonies.core.entity.ai.workers.util.MineNode;
import com.minecolonies.core.entity.ai.workers.util.MinerLevel;
import com.minecolonies.core.entity.pathfinding.proxy.AbstractWalkToProxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;

public class EntityCitizenWalkToProxy
extends AbstractWalkToProxy {
    private static final int OTHER_SIDE_OF_SHAFT = 6;
    private final AbstractEntityCitizen citizen;

    public EntityCitizenWalkToProxy(AbstractEntityCitizen entity) {
        super((Mob)entity);
        this.citizen = entity;
    }

    @Override
    public Set<BlockPos> getWayPoints() {
        if (this.citizen.getCitizenColonyHandler().getColonyOrRegister() == null) {
            return Collections.emptySet();
        }
        return this.citizen.getCitizenColonyHandler().getColonyOrRegister().getWayPoints().keySet();
    }

    @Override
    public boolean careAboutY() {
        return true;
    }

    @Override
    public BlockPos getSpecializedProxy(BlockPos target, double distanceToPath) {
        IBuilding miner;
        AbstractBuildingGuards guardbuilding;
        IBuilding building = this.citizen.getCitizenColonyHandler().getWorkBuilding();
        if (this.citizen.getCitizenJobHandler().getColonyJob() != null && this.citizen.getCitizenJobHandler().getColonyJob() instanceof JobMiner && building instanceof BuildingMiner) {
            return this.getMinerProxy(target, distanceToPath, (BuildingMiner)building);
        }
        if (this.citizen.getCitizenJobHandler().getColonyJob() != null && this.citizen.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard && building instanceof AbstractBuildingGuards && (guardbuilding = (AbstractBuildingGuards)building).getTask().equals("com.minecolonies.core.guard.setting.patrol_mine") && guardbuilding.getMinePos() != null && (miner = this.citizen.getCitizenColonyHandler().getColonyOrRegister().getBuildingManager().getBuilding(guardbuilding.getMinePos())) instanceof BuildingMiner) {
            return this.getMinerProxy(target, distanceToPath, (BuildingMiner)miner);
        }
        return null;
    }

    @NotNull
    private BlockPos getMinerProxy(BlockPos target, double distanceToPath, @NotNull BuildingMiner building) {
        MinerLevelManagementModule module = (MinerLevelManagementModule)building.getFirstModuleOccurance(MinerLevelManagementModule.class);
        MinerLevel level = module.getCurrentLevel();
        BlockPos ladderPos = building.getLadderLocation();
        if (level != null) {
            BlockPos vector = building.getLadderLocation().subtract((Vec3i)building.getCobbleLocation());
            int levelDepth = level.getDepth() + 2;
            int targetY = target.getY();
            int workerY = this.citizen.blockPosition().getY();
            if (workerY <= levelDepth && targetY > levelDepth) {
                if (module.getActiveNode() != null && module.getActiveNode().getParent() != null) {
                    MineNode currentNode = level.getNode(module.getActiveNode().getParent());
                    if (currentNode == null) {
                        module.setActiveNode(null);
                        module.setOldNode(null);
                        return this.getProxy(target, this.citizen.blockPosition(), distanceToPath);
                    }
                    while (currentNode.getParent() != null) {
                        if (currentNode.getStyle() == MineNode.NodeType.SHAFT) {
                            Direction facing = BlockPosUtil.getXZFacing(ladderPos, new BlockPos(currentNode.getX(), 0, currentNode.getZ()));
                            BlockPos ladderHeight = new BlockPos(ladderPos.getX(), targetY + 1, ladderPos.getZ());
                            return new BlockPos((Vec3i)ladderHeight.relative(facing, 7));
                        }
                        this.addToProxyList(new BlockPos(currentNode.getX(), levelDepth, currentNode.getZ()));
                        currentNode = level.getNode(currentNode.getParent());
                    }
                }
                this.addToProxyList(new BlockPos(ladderPos.getX() + vector.getX() * 6, level.getDepth(), ladderPos.getZ() + vector.getZ() * 6));
                return this.getProxy(target, this.citizen.blockPosition(), distanceToPath);
            }
            if (targetY <= levelDepth && workerY > levelDepth) {
                BlockPos buildingPos = building.getPosition();
                BlockPos newProxy = this.getProxy(buildingPos, this.citizen.blockPosition(), BlockPosUtil.getDistanceSquared(this.citizen.blockPosition(), buildingPos));
                if (buildingPos.getY() - level.getDepth() > 25) {
                    this.addToProxyList(new BlockPos(ladderPos.getX() + vector.getX(), level.getDepth() + (buildingPos.getY() - level.getDepth()) / 2, ladderPos.getZ() + vector.getZ()));
                }
                this.addToProxyList(new BlockPos(ladderPos.getX() + vector.getX() * 6, level.getDepth(), ladderPos.getZ() + vector.getZ() * 6));
                if (module.getActiveNode() != null && module.getActiveNode().getParent() != null) {
                    this.calculateNodes(level, levelDepth, building);
                }
                return newProxy;
            }
            if (targetY <= levelDepth) {
                double closestNode = Double.MAX_VALUE;
                MineNode lastNode = null;
                for (Map.Entry<Vec2i, MineNode> node : level.getNodes().entrySet()) {
                    double distanceToNode = node.getKey().distanceSq(this.citizen.blockPosition().getX(), this.citizen.blockPosition().getZ());
                    if (!(distanceToNode < closestNode)) continue;
                    lastNode = node.getValue();
                    closestNode = distanceToNode;
                }
                if (lastNode != null && lastNode.getStyle() == MineNode.NodeType.SHAFT) {
                    Direction facing = BlockPosUtil.getXZFacing(ladderPos, new BlockPos(lastNode.getX(), 0, lastNode.getZ()));
                    BlockPos ladderHeight = new BlockPos(ladderPos.getX(), targetY + 1, ladderPos.getZ());
                    return new BlockPos((Vec3i)ladderHeight.relative(facing, 7));
                }
                if (lastNode != null && lastNode.getParent() != null) {
                    MineNode currentNode = level.getNode(lastNode.getParent());
                    while (new Vec2i(currentNode.getX(), currentNode.getZ()).equals(currentNode.getParent()) && currentNode.getParent() != null) {
                        this.addToProxyList(new BlockPos(currentNode.getX(), levelDepth, currentNode.getZ()));
                        currentNode = level.getNode(currentNode.getParent());
                    }
                }
                if (module.getActiveNode() != null && module.getActiveNode().getParent() != null) {
                    this.calculateNodes(level, levelDepth, building);
                }
                if (!this.getProxyList().isEmpty()) {
                    return this.getProxyList().get(0);
                }
                return target;
            }
        }
        return this.getProxy(target, this.citizen.blockPosition(), distanceToPath);
    }

    private void calculateNodes(MinerLevel level, int levelDepth, BuildingMiner buildingMiner) {
        ArrayList<BlockPos> nodesToTarget = new ArrayList<BlockPos>();
        MineNode currentNode = level.getNode(((MinerLevelManagementModule)buildingMiner.getFirstModuleOccurance(MinerLevelManagementModule.class)).getActiveNode().getParent());
        while (currentNode != null && currentNode.getParent() != null) {
            if (currentNode.getStyle() == MineNode.NodeType.SHAFT) {
                BlockPos ladderPos = buildingMiner.getLadderLocation();
                Direction facing = BlockPosUtil.getXZFacing(ladderPos, new BlockPos(currentNode.getX(), 0, currentNode.getZ()));
                BlockPos ladderHeight = new BlockPos(ladderPos.getX(), levelDepth + 1, ladderPos.getZ());
                nodesToTarget.add(new BlockPos((Vec3i)ladderHeight.relative(facing, 7)));
            } else {
                nodesToTarget.add(new BlockPos(currentNode.getX(), levelDepth, currentNode.getZ()));
            }
            currentNode = level.getNode(currentNode.getParent());
        }
        for (int i = nodesToTarget.size() - 1; i >= 0; --i) {
            this.addToProxyList((BlockPos)nodesToTarget.get(i));
        }
    }

    @Override
    public boolean isLivingAtSiteWithMove(Mob entity, int x, int y, int z, int range) {
        if (!EntityCitizenWalkToProxy.isWorkerAtSiteWithMove((AbstractEntityCitizen)entity, x, y, z, range)) {
            EntityUtils.tryMoveLivingToXYZ(entity, x, y, z);
            return false;
        }
        return true;
    }

    public static boolean isWorkerAtSiteWithMove(@NotNull AbstractEntityCitizen worker, int x, int y, int z, int range) {
        if (!EntityUtils.isLivingAtSiteWithMove((LivingEntity)worker, x, y, z, range)) {
            if (worker.getNavigation().isDone()) {
                EntityUtils.tryMoveLivingToXYZ((Mob)worker, x, y, z);
            }
            return false;
        }
        return true;
    }
}

