/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.other;

import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.util.EntityUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SittingEntity
extends Entity {
    int maxLifeTime = 100;
    private BlockPos sittingpos = BlockPos.ZERO;

    public SittingEntity(EntityType<?> type, Level worldIn) {
        super(type, worldIn);
        this.setInvisible(true);
        this.noPhysics = true;
        this.setNoGravity(true);
    }

    public SittingEntity(EntityType<?> type, Level worldIn, double x, double y, double z, int lifeTime) {
        super(type, worldIn);
        this.setPos(x, y, z);
        this.setInvisible(true);
        this.noPhysics = true;
        this.setNoGravity(true);
        this.maxLifeTime = lifeTime;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    public boolean isPickable() {
        return false;
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        if (this.level().isClientSide) {
            return;
        }
        if (!this.isVehicle() || this.maxLifeTime-- < 0) {
            if (this.getPassengers().size() > 0) {
                this.ejectPassengers();
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void addPassenger(Entity passenger) {
        super.addPassenger(passenger);
        if (this.level().isClientSide) {
            return;
        }
        passenger.dimensions = passenger.getType().getDimensions().scale(1.0f, 0.5f);
    }

    protected void removePassenger(Entity passenger) {
        super.removePassenger(passenger);
        if (this.level().isClientSide) {
            return;
        }
        if (passenger instanceof LivingEntity) {
            passenger.dimensions = ((LivingEntity)passenger).isBaby() ? passenger.getType().getDimensions().scale(0.5f) : passenger.getType().getDimensions();
        }
    }

    @NotNull
    public Vec3 getDismountLocationForPassenger(@NotNull LivingEntity passenger) {
        BlockPos start = this.sittingpos == BlockPos.ZERO ? this.blockPosition().above() : this.sittingpos;
        BlockPos spawn = EntityUtils.getSpawnPoint(this.level(), start);
        if (spawn == null) {
            return super.getDismountLocationForPassenger(passenger);
        }
        return new Vec3((double)spawn.getX() + 0.5, (double)spawn.getY() + 0.2, (double)spawn.getZ() + 0.5);
    }

    public void setMaxLifeTime(int maxLifeTime) {
        this.maxLifeTime = maxLifeTime;
    }

    public void setSittingPos(BlockPos pos) {
        this.sittingpos = pos;
    }

    public static void sitDown(BlockPos pos, Mob entity, int maxLifeTime) {
        if (entity.getVehicle() != null) {
            return;
        }
        SittingEntity sittingEntity = (SittingEntity)ModEntities.SITTINGENTITY.create(entity.level());
        BlockState state = entity.level().getBlockState(pos);
        double minY = 1.0;
        List shapes = state.getCollisionShape((BlockGetter)entity.level(), pos).toAabbs();
        for (AABB box : shapes) {
            if (!(box.maxY < minY)) continue;
            minY = box.maxY;
        }
        if (shapes.isEmpty()) {
            minY = 0.0;
        }
        entity.getNavigation().stop();
        sittingEntity.setPos((double)pos.getX() + 0.5, (double)pos.getY() + minY - (double)(entity.getBbHeight() / 2.0f), (double)pos.getZ() + 0.5);
        sittingEntity.setMaxLifeTime(maxLifeTime);
        sittingEntity.setSittingPos(pos);
        entity.level().addFreshEntity((Entity)sittingEntity);
        entity.startRiding((Entity)sittingEntity);
    }
}

