/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.citizen.citizenhandlers;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenFoodHandler;
import com.minecolonies.api.items.IMinecoloniesFoodItem;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import java.util.HashSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class CitizenFoodHandler
implements ICitizenFoodHandler {
    private static final int FOOD_QUEUE_SIZE = 10;
    private final ICitizenData citizenData;
    private final EvictingQueue<Item> lastEatenFoods = EvictingQueue.create((int)10);
    private ICitizenFoodHandler.CitizenFoodStats foodStatCache = null;
    private boolean dirty = false;

    public CitizenFoodHandler(ICitizenData citizenData) {
        this.citizenData = citizenData;
    }

    @Override
    public void addLastEaten(Item item) {
        this.lastEatenFoods.add((Object)item);
        this.citizenData.markDirty(20);
        this.dirty = true;
        if (this.lastEatenFoods.size() >= 10) {
            this.citizenData.triggerInteraction(new StandardInteraction((Component)Component.translatable((String)"com.minecolonies.coremod.entity.citizen.no.fooddiversity"), ChatPriority.IMPORTANT));
            this.citizenData.triggerInteraction(new StandardInteraction((Component)Component.translatable((String)"com.minecolonies.coremod.entity.citizen.no.foodquality"), ChatPriority.IMPORTANT));
            this.citizenData.triggerInteraction(new StandardInteraction((Component)Component.translatable((String)"com.minecolonies.coremod.entity.citizen.no.fooddiversity.urgent"), ChatPriority.BLOCKING));
            this.citizenData.triggerInteraction(new StandardInteraction((Component)Component.translatable((String)"com.minecolonies.coremod.entity.citizen.no.foodquality.urgent"), ChatPriority.BLOCKING));
        }
    }

    @Override
    public Item getLastEaten() {
        return (Item)this.lastEatenFoods.peek();
    }

    @Override
    public int checkLastEaten(Item item) {
        int foundIndex = -1;
        int index = -1;
        for (Item foodItem : this.lastEatenFoods) {
            ++index;
            if (foodItem != item) continue;
            foundIndex = index;
        }
        return foundIndex;
    }

    @Override
    public ICitizenFoodHandler.CitizenFoodStats getFoodHappinessStats() {
        if (this.foodStatCache == null || this.dirty) {
            int qualityFoodCounter = 0;
            HashSet<Item> uniqueFoods = new HashSet<Item>();
            for (Item foodItem : this.lastEatenFoods) {
                if (foodItem instanceof IMinecoloniesFoodItem) {
                    ++qualityFoodCounter;
                }
                uniqueFoods.add(foodItem);
            }
            this.foodStatCache = new ICitizenFoodHandler.CitizenFoodStats(Math.max(1, uniqueFoods.size()), qualityFoodCounter);
        }
        return this.foodStatCache;
    }

    @Override
    public boolean hasFullFoodHistory() {
        return this.lastEatenFoods.size() >= 10;
    }

    @Override
    public void read(CompoundTag compound) {
        @NotNull ListTag lastFoodNbt = compound.getList("lastfoods", 8);
        for (int i = 0; i < lastFoodNbt.size(); ++i) {
            Item lastFood = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)lastFoodNbt.getString(i)));
            if (lastFood == Items.AIR) continue;
            this.lastEatenFoods.add((Object)lastFood);
        }
    }

    @Override
    public void write(CompoundTag compound) {
        @NotNull ListTag lastEatenFoodsNBT = new ListTag();
        for (Item foodItem : this.lastEatenFoods) {
            lastEatenFoodsNBT.add((Object)StringTag.valueOf((String)BuiltInRegistries.ITEM.getKey((Object)foodItem).toString()));
        }
        compound.put("lastfoods", (Tag)lastEatenFoodsNBT);
    }

    @Override
    public double getDiseaseModifier(double baseModifier) {
        if (this.lastEatenFoods.size() < 10 || baseModifier == 0.0) {
            return baseModifier;
        }
        return baseModifier * 0.5 * Math.min(2.5, 5.0 / (double)this.getFoodHappinessStats().diversity());
    }

    @Override
    public ImmutableList<Item> getLastEatenFoods() {
        return ImmutableList.copyOf(this.lastEatenFoods);
    }
}

