/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.production.herders;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.StatsUtil;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingCowboy;
import com.minecolonies.core.colony.jobs.JobCowboy;
import com.minecolonies.core.entity.ai.workers.production.herders.AbstractEntityAIHerder;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkCowboy
extends AbstractEntityAIHerder<JobCowboy, BuildingCowboy> {
    public static final String RENDER_META_BUCKET = "bucket";
    public static final String RENDER_META_BOWL = "bowl";
    private static final VisibleCitizenStatus HERD_COW = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/cowboy.png"), "com.minecolonies.gui.visiblestatus.cowboy");
    private static final int MILK_COOL_DOWN = 10;
    private int milkCoolDown;
    private int stewCoolDown;

    public EntityAIWorkCowboy(@NotNull JobCowboy job) {
        super(job);
        super.registerTargets(new AITarget<Object>(AIWorkerState.COWBOY_MILK, this::milkCows, 1), new AITarget<Object>(AIWorkerState.COWBOY_STEW, this::milkMooshrooms, 1));
    }

    @Override
    protected void updateRenderMetaData() {
        Object renderMeta;
        Object object = renderMeta = this.getState() == AIWorkerState.IDLE ? "" : "working";
        if (this.worker.getCitizenInventoryHandler().hasItemInInventory(Items.BUCKET) || this.worker.getCitizenInventoryHandler().hasItemInInventory(ModItems.large_empty_bottle)) {
            renderMeta = (String)renderMeta + RENDER_META_BUCKET;
        }
        if (this.worker.getCitizenInventoryHandler().hasItemInInventory(Items.BOWL)) {
            renderMeta = (String)renderMeta + RENDER_META_BOWL;
        }
        this.worker.setRenderMetadata((String)renderMeta);
    }

    @Override
    public Class<BuildingCowboy> getExpectedBuildingClass() {
        return BuildingCowboy.class;
    }

    @Override
    public IAIState decideWhatToDo() {
        IAIState result = super.decideWhatToDo();
        if (this.milkCoolDown > 0) {
            --this.milkCoolDown;
        } else if (this.building != null && ((BuildingCowboy.HerdingModule)((BuildingCowboy)this.building).getFirstModuleOccurance(BuildingCowboy.HerdingModule.class)).canTryToMilk() && result.equals(AIWorkerState.START_WORKING)) {
            return AIWorkerState.COWBOY_MILK;
        }
        if (this.stewCoolDown > 0) {
            --this.stewCoolDown;
        } else if (this.building != null && ((BuildingCowboy.HerdingModule)((BuildingCowboy)this.building).getFirstModuleOccurance(BuildingCowboy.HerdingModule.class)).canTryToStew() && result.equals(AIWorkerState.START_WORKING)) {
            return AIWorkerState.COWBOY_STEW;
        }
        return result;
    }

    @Override
    public List<ItemStorage> getExtraItemsNeeded() {
        List<ItemStorage> list = super.getExtraItemsNeeded();
        if (this.building != null && ((BuildingCowboy.HerdingModule)((BuildingCowboy)this.building).getFirstModuleOccurance(BuildingCowboy.HerdingModule.class)).canTryToMilk() && !this.searchForAnimals(a -> a instanceof Cow && !(a instanceof MushroomCow)).isEmpty()) {
            ItemStorage stack = new ItemStorage(((BuildingCowboy)this.building).getMilkInputItem().copy());
            stack.setAmount(((BuildingCowboy)this.building).getSetting(BuildingCowboy.MILKING_AMOUNT).getValue());
            list.add(stack);
        }
        if (this.building != null && ((BuildingCowboy.HerdingModule)((BuildingCowboy)this.building).getFirstModuleOccurance(BuildingCowboy.HerdingModule.class)).canTryToStew() && !this.searchForAnimals(a -> a instanceof MushroomCow).isEmpty()) {
            list.add(new ItemStorage(Items.BOWL));
        }
        return list;
    }

    private IAIState milkCows() {
        Cow cow;
        this.worker.getCitizenData().setVisibleStatus(HERD_COW);
        if (!this.worker.getCitizenInventoryHandler().hasItemInInventory(((BuildingCowboy)this.building).getMilkInputItem().getItem())) {
            if (InventoryUtils.hasBuildingEnoughElseCount((IBuilding)this.building, new ItemStorage(((BuildingCowboy)this.building).getMilkInputItem()), 1) > 0 && this.walkToBuilding()) {
                this.checkAndTransferFromHut(((BuildingCowboy)this.building).getMilkInputItem());
            } else {
                this.milkCoolDown = 10;
                return AIWorkerState.DECIDE;
            }
        }
        if ((cow = (Cow)this.searchForAnimals(a -> a instanceof Cow && !(a instanceof MushroomCow) && !a.isBaby()).stream().map(a -> (Cow)a).findFirst().orElse(null)) == null) {
            this.milkCoolDown = 10;
            return AIWorkerState.DECIDE;
        }
        if (this.equipItem(InteractionHand.MAIN_HAND, Collections.singletonList(((BuildingCowboy)this.building).getMilkInputItem())) && !this.walkingToAnimal((Animal)cow)) {
            if (InventoryUtils.addItemStackToItemHandler((IItemHandler)this.worker.getInventoryCitizen(), ((BuildingCowboy)this.building).getMilkOutputItem())) {
                ((BuildingCowboy.HerdingModule)((BuildingCowboy)this.building).getFirstModuleOccurance(BuildingCowboy.HerdingModule.class)).onMilked();
                CitizenItemUtils.removeHeldItem(this.worker);
                this.equipItem(InteractionHand.MAIN_HAND, Collections.singletonList(((BuildingCowboy)this.building).getMilkOutputItem()));
                InventoryUtils.tryRemoveStackFromItemHandler((IItemHandler)this.worker.getInventoryCitizen(), ((BuildingCowboy)this.building).getMilkInputItem());
            }
            this.incrementActionsDoneAndDecSaturation();
            StatsUtil.trackStat(this.building, "milking_attempts", 1);
            this.worker.getCitizenExperienceHandler().addExperience(1.0);
            return AIWorkerState.INVENTORY_FULL;
        }
        return AIWorkerState.DECIDE;
    }

    private IAIState milkMooshrooms() {
        MushroomCow mooshroom;
        this.worker.getCitizenData().setVisibleStatus(HERD_COW);
        if (!this.worker.getCitizenInventoryHandler().hasItemInInventory(Items.BOWL)) {
            if (InventoryUtils.hasBuildingEnoughElseCount((IBuilding)this.building, new ItemStorage(new ItemStack((ItemLike)Items.BOWL, 1)), 1) > 0 && this.walkToBuilding()) {
                this.checkAndTransferFromHut(new ItemStack((ItemLike)Items.BOWL, 1));
            } else {
                this.stewCoolDown = 10;
                return AIWorkerState.DECIDE;
            }
        }
        if ((mooshroom = (MushroomCow)this.searchForAnimals(a -> a instanceof MushroomCow && !a.isBaby()).stream().map(a -> (MushroomCow)a).findFirst().orElse(null)) == null) {
            this.stewCoolDown = 10;
            return AIWorkerState.DECIDE;
        }
        if (this.equipItem(InteractionHand.MAIN_HAND, Collections.singletonList(new ItemStack((ItemLike)Items.BOWL))) && !this.walkingToAnimal((Animal)mooshroom)) {
            FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.worker.level()));
            fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.BOWL));
            if (mooshroom.mobInteract((Player)fakePlayer, InteractionHand.MAIN_HAND).equals((Object)InteractionResult.CONSUME)) {
                if (InventoryUtils.addItemStackToItemHandler((IItemHandler)this.worker.getInventoryCitizen(), fakePlayer.getMainHandItem())) {
                    ((BuildingCowboy.HerdingModule)((BuildingCowboy)this.building).getFirstModuleOccurance(BuildingCowboy.HerdingModule.class)).onStewed();
                    CitizenItemUtils.removeHeldItem(this.worker);
                    this.equipItem(InteractionHand.MAIN_HAND, Collections.singletonList(fakePlayer.getMainHandItem()));
                    InventoryUtils.tryRemoveStackFromItemHandler((IItemHandler)this.worker.getInventoryCitizen(), new ItemStack((ItemLike)Items.BOWL));
                }
                fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            }
            this.incrementActionsDoneAndDecSaturation();
            StatsUtil.trackStat(this.building, "milking_attempts", 1);
            this.worker.getCitizenExperienceHandler().addExperience(1.0);
            return AIWorkerState.INVENTORY_FULL;
        }
        return AIWorkerState.DECIDE;
    }

    @Override
    public double getButcheringAttackDamage() {
        return Math.max(1.0, (double)this.getPrimarySkillLevel() / 10.0);
    }

    @Override
    protected IAIState breedAnimals() {
        this.worker.getCitizenData().setVisibleStatus(HERD_COW);
        return super.breedAnimals();
    }

    @Override
    protected IAIState butcherAnimals() {
        this.worker.getCitizenData().setVisibleStatus(HERD_COW);
        return super.butcherAnimals();
    }
}

