/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.education;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.IItemHandlerCapProvider;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingLibrary;
import com.minecolonies.core.colony.jobs.JobStudent;
import com.minecolonies.core.datalistener.StudyItemListener;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAISkill;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIStudy
extends AbstractEntityAISkill<JobStudent, BuildingLibrary> {
    public static final String RENDER_META_BOOK = "book";
    public static final String RENDER_META_STUDYING = "study";
    public static final int ONE_IN_X_CHANCE = 8;
    private static final int STUDY_DELAY = 1200;
    private BlockPos studyPos = null;

    public EntityAIStudy(@NotNull JobStudent job) {
        super(job);
        super.registerTargets(new AITarget<AIWorkerState>(AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget<Object>(AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget<Object>(AIWorkerState.STUDY, this::study, 5));
        this.worker.setCanPickUpLoot(true);
    }

    @Override
    public Class<BuildingLibrary> getExpectedBuildingClass() {
        return BuildingLibrary.class;
    }

    @Override
    protected void updateRenderMetaData() {
        Object renderMeta;
        Object object = renderMeta = this.getState() == AIWorkerState.IDLE ? "" : "working";
        if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), itemStack -> itemStack.getItem() == Items.BOOK || itemStack.getItem() == Items.PAPER)) {
            renderMeta = (String)renderMeta + RENDER_META_BOOK;
        }
        if (this.worker.getNavigation().isDone()) {
            renderMeta = (String)renderMeta + RENDER_META_STUDYING;
        }
        this.worker.setRenderMetadata((String)renderMeta);
    }

    private IAIState study() {
        ICitizenData data = this.worker.getCitizenData();
        if (this.studyPos == null) {
            this.studyPos = ((BuildingLibrary)this.building).getRandomBookShelf();
        }
        if (!this.walkToWorkPos(this.studyPos)) {
            this.setDelay(20);
            return this.getState();
        }
        Collection<StudyItemListener.StudyItem> studyItems = StudyItemListener.getAllStudyItems().values();
        ArrayList<StudyItemListener.StudyItem> availableItemKeys = new ArrayList<StudyItemListener.StudyItem>();
        HashMap<StudyItemListener.StudyItem, Integer> availableItems = new HashMap<StudyItemListener.StudyItem, Integer>();
        for (StudyItemListener.StudyItem curItem : studyItems) {
            int slot = InventoryUtils.findFirstSlotInProviderNotEmptyWith((IItemHandlerCapProvider)this.worker, item -> item.is(curItem.item()));
            if (slot == -1) continue;
            availableItemKeys.add(curItem);
            availableItems.put(curItem, slot);
        }
        if (availableItems.isEmpty()) {
            ArrayList<ItemStack> itemsToRequest = new ArrayList<ItemStack>();
            int amountToRequest = 1;
            for (StudyItemListener.StudyItem studyItem : studyItems) {
                int bSlot = InventoryUtils.findFirstSlotInProviderWith((IItemHandlerCapProvider)this.building, studyItem.item());
                if (bSlot > -1) {
                    this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(itemStack -> studyItem.item() == itemStack.getItem(), 10);
                    return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
                }
                ItemStack itemStack2 = new ItemStack((ItemLike)studyItem.item(), studyItem.item().getDefaultInstance().getMaxStackSize());
                itemsToRequest.add(itemStack2);
                amountToRequest = Math.max(amountToRequest, studyItem.breakChance() / 10 > 0 ? studyItem.breakChance() : 1);
            }
            this.checkIfRequestForItemExistOrCreate(new StackList(itemsToRequest, "Study Items", amountToRequest));
            data.getCitizenSkillHandler().tryLevelUpIntelligence(data.getRandom(), 8.0, data);
            this.worker.setItemInHand(InteractionHand.MAIN_HAND, ItemStackUtils.EMPTY);
        } else {
            StudyItemListener.StudyItem chosenItem = (StudyItemListener.StudyItem)availableItemKeys.get(this.world.random.nextInt(availableItems.size()));
            int chosenSlot = (Integer)availableItems.get(chosenItem);
            this.worker.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)chosenItem.item(), 1));
            if (data.getCitizenSkillHandler().tryLevelUpIntelligence(data.getRandom(), 8.0 * (10.0 / (double)chosenItem.skillIncreaseChance()), data)) {
                ((BuildingLibrary)this.building).getModule(BuildingModules.STATS_MODULE).increment("int_leveled");
            }
            if (this.world.random.nextInt(100) <= chosenItem.breakChance()) {
                data.getInventory().extractItem(chosenSlot, 1, false);
                ((BuildingLibrary)this.building).getModule(BuildingModules.STATS_MODULE).increment("item_used;" + chosenItem.item().getDescriptionId());
            }
        }
        this.worker.decreaseSaturationForAction();
        this.studyPos = null;
        this.worker.queueSound(SoundEvents.BOOK_PAGE_TURN, this.worker.blockPosition().above(), 80, 15, 0.25f, 1.5f);
        this.setDelay(1200);
        return this.getState();
    }

    private IAIState startWorkingAtOwnBuilding() {
        if (!this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.STUDY;
    }
}

