/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.builder;

import com.ldtteam.structurize.placement.StructurePlacer;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.workorders.IBuilderWorkOrder;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.buildings.modules.settings.BuilderModeSetting;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.core.colony.jobs.JobBuilder;
import com.minecolonies.core.colony.workorders.WorkOrderBuilding;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIStructureWithWorkOrder;
import com.minecolonies.core.entity.ai.workers.util.BuildingProgressStage;
import com.minecolonies.core.entity.ai.workers.util.BuildingStructureHandler;
import com.minecolonies.core.entity.pathfinding.navigation.AbstractAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.navigation.MinecoloniesAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobMoveCloseToXNearY;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class EntityAIStructureBuilder
extends AbstractEntityAIStructureWithWorkOrder<JobBuilder, BuildingBuilder> {
    private static final double SPEED_BUFF_0 = 0.5;
    private static final int ACTIONS_UNTIL_DUMP = 4096;
    private static final int LEVEL_TO_PURGE_MOBS = 4;
    PathResult gotoPath = null;

    public EntityAIStructureBuilder(@NotNull JobBuilder job) {
        super(job);
        super.registerTargets(new AITarget<AIWorkerState>(AIWorkerState.IDLE, AIWorkerState.START_WORKING, 100), new AITarget<Object>(AIWorkerState.START_WORKING, this::checkForWorkOrder, this::startWorkingAtOwnBuilding, 100));
        this.worker.setCanPickUpLoot(true);
    }

    @Override
    public int getBreakSpeedLevel() {
        return this.getSecondarySkillLevel();
    }

    @Override
    public int getPlaceSpeedLevel() {
        return this.getPrimarySkillLevel();
    }

    @Override
    public Class<BuildingBuilder> getExpectedBuildingClass() {
        return BuildingBuilder.class;
    }

    private boolean checkForWorkOrder() {
        if (!((JobBuilder)this.job).hasWorkOrder()) {
            ((BuildingBuilder)this.building).searchWorkOrder();
            ((BuildingBuilder)this.building).setProgressPos(null, BuildingProgressStage.CLEAR);
            this.worker.getCitizenData().setStatusPosition(null);
            return false;
        }
        IBuilderWorkOrder wo = ((JobBuilder)this.job).getWorkOrder();
        if (wo == null) {
            ((JobBuilder)this.job).setWorkOrder(null);
            ((BuildingBuilder)this.building).setProgressPos(null, null);
            this.worker.getCitizenData().setStatusPosition(null);
            return false;
        }
        IBuilding building = ((JobBuilder)this.job).getColony().getBuildingManager().getBuilding(wo.getLocation());
        if (building == null && wo instanceof WorkOrderBuilding && wo.getWorkOrderType() != WorkOrderType.REMOVE) {
            ((JobBuilder)this.job).complete();
            return false;
        }
        return true;
    }

    @Override
    public void setStructurePlacer(BuildingStructureHandler<JobBuilder, BuildingBuilder> structure) {
        if (((JobBuilder)this.job).getWorkOrder().getIteratorType().isEmpty()) {
            String mode = BuilderModeSetting.getActualValue(this.building);
            ((JobBuilder)this.job).getWorkOrder().setIteratorType(mode);
        }
        this.structurePlacer = new Tuple<StructurePlacer, BuildingStructureHandler<JobBuilder, BuildingBuilder>>(new StructurePlacer(structure, ((JobBuilder)this.job).getWorkOrder().getIteratorType()), structure);
    }

    @Override
    public boolean isAfterDumpPickupAllowed() {
        return !this.checkForWorkOrder();
    }

    private IAIState startWorkingAtOwnBuilding() {
        if (!this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.LOAD_STRUCTURE;
    }

    private void killMobs() {
        if (((BuildingBuilder)this.building).getBuildingLevel() >= 4 && ((JobBuilder)this.job).getWorkOrder() != null && ((JobBuilder)this.job).getWorkOrder().getWorkOrderType() == WorkOrderType.BUILD) {
            BlockPos buildingPos = ((JobBuilder)this.job).getWorkOrder().getLocation();
            IBuilding building = this.worker.getCitizenColonyHandler().getColonyOrRegister().getBuildingManager().getBuilding(buildingPos);
            if (building != null) {
                WorldUtil.getEntitiesWithinBuilding((Level)this.world, Monster.class, building, null).forEach(e -> e.remove(Entity.RemovalReason.DISCARDED));
            }
        }
    }

    @Override
    public void checkForExtraBuildingActions() {
        if (!((BuildingBuilder)this.building).hasPurgedMobsToday()) {
            this.killMobs();
            ((BuildingBuilder)this.building).setPurgedMobsToday(true);
        }
    }

    @Override
    protected boolean mineBlock(@NotNull BlockPos blockToMine, @NotNull BlockPos safeStand) {
        return this.mineBlock(blockToMine, safeStand, true, !IColonyManager.getInstance().getCompatibilityManager().isOre(this.world.getBlockState(blockToMine)), null);
    }

    @Override
    public IAIState afterRequestPickUp() {
        return AIWorkerState.INVENTORY_FULL;
    }

    @Override
    public IAIState afterDump() {
        return AIWorkerState.PICK_UP;
    }

    @Override
    public boolean walkToConstructionSite(BlockPos currentBlock) {
        if (this.workFrom != null && this.workFrom.getX() == currentBlock.getX() && this.workFrom.getZ() == currentBlock.getZ() && this.workFrom.getY() >= currentBlock.getY()) {
            this.workFrom = null;
        }
        if (this.workFrom == null) {
            if (this.gotoPath == null || this.gotoPath.isCancelled()) {
                PathJobMoveCloseToXNearY pathJob = new PathJobMoveCloseToXNearY((Level)this.world, currentBlock, ((JobBuilder)this.job).getWorkOrder().getLocation(), 4, (Mob)this.worker);
                this.gotoPath = ((MinecoloniesAdvancedPathNavigate)this.worker.getNavigation()).setPathJob(pathJob, currentBlock, 1.0, false);
                pathJob.getPathingOptions().dropCost = 200.0;
                pathJob.extraNodes = 0;
            } else if (this.gotoPath.isDone()) {
                if (this.gotoPath.getPath() != null) {
                    this.workFrom = this.gotoPath.getPath().getTarget();
                }
                this.gotoPath = null;
            }
            if (this.prevBlockPosition != null) {
                return BlockPosUtil.dist(this.prevBlockPosition, currentBlock) <= 10.0;
            }
            return false;
        }
        if (!this.walkToSafePos(this.workFrom)) {
            MinecoloniesAdvancedPathNavigate pathNavigate;
            AbstractAdvancedPathNavigate abstractAdvancedPathNavigate = this.worker.getNavigation();
            if (abstractAdvancedPathNavigate instanceof MinecoloniesAdvancedPathNavigate && (pathNavigate = (MinecoloniesAdvancedPathNavigate)abstractAdvancedPathNavigate).getStuckHandler().getStuckLevel() > 0) {
                this.workFrom = null;
            }
            return false;
        }
        if (BlockPosUtil.getDistance2D(this.worker.blockPosition(), currentBlock) > 5L) {
            if (BlockPosUtil.dist(this.workFrom, ((JobBuilder)this.job).getWorkOrder().getLocation()) < 100.0) {
                this.prevBlockPosition = currentBlock;
                this.workFrom = null;
                return true;
            }
            this.workFrom = null;
            return false;
        }
        this.prevBlockPosition = currentBlock;
        return true;
    }

    @Override
    public boolean shallReplaceSolidSubstitutionBlock(Block worldBlock, BlockState worldMetadata) {
        return false;
    }

    @Override
    public int getBlockMiningTime(@NotNull BlockState state, @NotNull BlockPos pos) {
        return (int)((double)super.getBlockMiningTime(state, pos) * 0.5);
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 4096;
    }

    @Override
    protected void sendCompletionMessage(IWorkOrder wo) {
        super.sendCompletionMessage(wo);
        BlockPos position = wo.getLocation();
        boolean showManualSuffix = false;
        if (((BuildingBuilder)this.building).getManualMode()) {
            showManualSuffix = true;
            for (IWorkOrder iWorkOrder : ((BuildingBuilder)this.building).getColony().getWorkManager().getWorkOrders().values()) {
                if (iWorkOrder.getID() == wo.getID() || !((BuildingBuilder)this.building).getID().equals((Object)iWorkOrder.getClaimedBy())) continue;
                showManualSuffix = false;
            }
        }
        MutableComponent message = switch (wo.getWorkOrderType()) {
            case WorkOrderType.REPAIR -> Component.translatableEscape((String)"entity.builder.messagerepaircomplete", (Object[])new Object[]{wo.getDisplayName(), position.getX(), position.getY(), position.getZ()});
            case WorkOrderType.REMOVE -> Component.translatableEscape((String)"entity.builder.messageremovalcomplete", (Object[])new Object[]{wo.getDisplayName(), position.getX(), position.getY(), position.getZ()});
            default -> Component.translatableEscape((String)"entity.builder.messagebuildcomplete", (Object[])new Object[]{wo.getDisplayName(), position.getX(), position.getY(), position.getZ()});
        };
        if (showManualSuffix) {
            message.append((Component)Component.translatableEscape((String)"entity.builder.messagebuildmanualfinish", (Object[])new Object[0]));
        }
        MessageUtils.forCitizen(this.worker, (Component)message).sendTo(this.worker.getCitizenColonyHandler().getColonyOrRegister().getImportantMessageEntityPlayers());
    }
}

