/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AIEventTarget;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIBlockingEventType;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.FurnaceUserModule;
import com.minecolonies.core.colony.buildings.modules.ItemListModule;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.AbstractJob;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAISkill;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAIUsesFurnace<J extends AbstractJob<?, J>, B extends AbstractBuilding>
extends AbstractEntityAISkill<J, B> {
    protected static final double BASE_XP_GAIN = 2.0;
    private static final int RETRIEVE_SMELTABLE_IF_MORE_THAN = 10;
    private static final int STORAGE_BUFFER = 3;

    protected AbstractEntityAIUsesFurnace(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget<AIWorkerState>(AIWorkerState.IDLE, AIWorkerState.START_WORKING, 5), new AITarget<Object>(AIWorkerState.START_WORKING, this::startWorking, 60), new AITarget<Object>(AIWorkerState.START_USING_FURNACE, this::fillUpFurnace, 5), new AIEventTarget<Object>(AIBlockingEventType.AI_BLOCKING, this::accelerateFurnaces, 20), new AITarget<Object>(AIWorkerState.RETRIEVING_END_PRODUCT_FROM_FURNACE, this::retrieveSmeltableFromFurnace, 5), new AITarget<Object>(AIWorkerState.RETRIEVING_USED_FUEL_FROM_FURNACE, this::retrieveUsedFuel, 5));
    }

    protected abstract void extractFromFurnace(FurnaceBlockEntity var1);

    private void extractFuelFromFurnace(FurnaceBlockEntity furnace) {
        InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandler((IItemHandler)new InvWrapper((Container)furnace), 1, (IItemHandler)this.worker.getInventoryCitizen());
    }

    protected abstract boolean isSmeltable(ItemStack var1);

    protected boolean reachedMaxToKeep() {
        int count = InventoryUtils.countEmptySlotsInBuilding(this.building);
        return count <= 3;
    }

    protected BlockPos getPositionOfOvenToRetrieveFrom() {
        for (BlockPos pos : ((FurnaceUserModule)this.building.getFirstModuleOccurance(FurnaceUserModule.class)).getFurnaces()) {
            int countInInputSlot;
            BlockEntity entity = this.world.getBlockEntity(pos);
            if (!(entity instanceof FurnaceBlockEntity)) continue;
            FurnaceBlockEntity furnace = (FurnaceBlockEntity)entity;
            int countInResultSlot = ItemStackUtils.isEmpty(furnace.getItem(2)) ? 0 : furnace.getItem(2).getCount();
            int n = countInInputSlot = ItemStackUtils.isEmpty(furnace.getItem(0)) ? 0 : furnace.getItem(0).getCount();
            if ((furnace.isLit() || countInResultSlot <= 0) && countInResultSlot <= 10 && (countInResultSlot <= 0 || countInInputSlot != 0)) continue;
            return pos;
        }
        return null;
    }

    protected BlockPos getPositionOfOvenToRetrieveFuelFrom() {
        ItemListModule module = (ItemListModule)this.building.getModuleMatching(ItemListModule.class, m -> m.getId().equals("fuel"));
        for (BlockPos pos : ((FurnaceUserModule)this.building.getFirstModuleOccurance(FurnaceUserModule.class)).getFurnaces()) {
            FurnaceBlockEntity furnace;
            BlockEntity entity = this.world.getBlockEntity(pos);
            if (!(entity instanceof FurnaceBlockEntity) || (furnace = (FurnaceBlockEntity)entity).getItem(1).isEmpty() || module.isItemInList(new ItemStorage(furnace.getItem(1)))) continue;
            return pos;
        }
        return null;
    }

    public IAIState startWorking() {
        if (!this.walkToBuilding()) {
            return this.getState();
        }
        FurnaceUserModule furnaceModule = (FurnaceUserModule)this.building.getFirstModuleOccurance(FurnaceUserModule.class);
        ItemListModule itemListModule = (ItemListModule)this.building.getModuleMatching(ItemListModule.class, m -> m.getId().equals("fuel"));
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        if (itemListModule.getList().isEmpty()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.translatableEscape((String)"com.minecolonies.coremod.furnaceuser.nofuel", (Object[])new Object[0]), ChatPriority.BLOCKING));
            }
            return this.getState();
        }
        if (furnaceModule.getFurnaces().isEmpty()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.translatableEscape((String)"com.minecolonies.coremod.bakery.nofurnace", (Object[])new Object[0]), ChatPriority.BLOCKING));
            }
            return this.getState();
        }
        IAIState nextState = this.checkForImportantJobs();
        if (nextState != AIWorkerState.START_WORKING) {
            return nextState;
        }
        BlockPos posOfUsedFuelOven = this.getPositionOfOvenToRetrieveFuelFrom();
        if (posOfUsedFuelOven != null) {
            this.walkTo = posOfUsedFuelOven;
            return AIWorkerState.RETRIEVING_USED_FUEL_FROM_FURNACE;
        }
        BlockPos posOfOven = this.getPositionOfOvenToRetrieveFrom();
        if (posOfOven != null) {
            this.walkTo = posOfOven;
            return AIWorkerState.RETRIEVING_END_PRODUCT_FROM_FURNACE;
        }
        int amountOfSmeltableInBuilding = InventoryUtils.getCountFromBuilding((IBuilding)this.building, this::isSmeltable);
        int amountOfSmeltableInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this::isSmeltable);
        int amountOfFuelInBuilding = InventoryUtils.getCountFromBuilding((IBuilding)this.building, itemListModule.getList());
        int amountOfFuelInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> itemListModule.isItemInList(new ItemStorage((ItemStack)stack)));
        if (amountOfSmeltableInBuilding + amountOfSmeltableInInv <= 0 && !this.reachedMaxToKeep()) {
            this.requestSmeltable();
        }
        if (amountOfFuelInBuilding + amountOfFuelInInv <= 0 && !this.building.hasWorkerOpenRequestsFiltered(this.worker.getCitizenData().getId(), req -> req.getShortDisplayString().getSiblings().contains(Component.translatableEscape((String)"com.minecolonies.coremod.request.burnable", (Object[])new Object[0])))) {
            this.worker.getCitizenData().createRequestAsync(new StackList(this.getAllowedFuel(), "com.minecolonies.coremod.request.burnable", 64 * furnaceModule.getFurnaces().size(), 1));
        }
        if (amountOfSmeltableInBuilding > 0 && amountOfSmeltableInInv == 0) {
            this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(this::isSmeltable, 64);
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        if (amountOfFuelInBuilding > 0 && amountOfFuelInInv == 0) {
            this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(stack -> itemListModule.isItemInList(new ItemStorage((ItemStack)stack)), 64);
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        return this.checkIfAbleToSmelt(amountOfFuelInBuilding + amountOfFuelInInv, amountOfSmeltableInBuilding + amountOfSmeltableInInv);
    }

    private List<ItemStack> getAllowedFuel() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStorage storage : ((ItemListModule)this.building.getModuleMatching(ItemListModule.class, m -> m.getId().equals("fuel"))).getList()) {
            ItemStack stack = storage.getItemStack().copy();
            stack.setCount(stack.getMaxStackSize());
            list.add(stack);
        }
        return list;
    }

    private IAIState accelerateFurnaces() {
        int accelerationTicks = this.worker.getCitizenData().getCitizenSkillHandler().getLevel(this.getModuleForJob().getPrimarySkill()) / 10 * 2;
        Level world = this.building.getColony().getWorld();
        for (BlockPos pos : this.building.getModule(BuildingModules.FURNACE).getFurnaces()) {
            BlockEntity entity;
            if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos) || !((entity = world.getBlockEntity(pos)) instanceof FurnaceBlockEntity)) continue;
            FurnaceBlockEntity furnace = (FurnaceBlockEntity)entity;
            for (int i = 0; i < accelerationTicks; ++i) {
                if (!furnace.isLit()) continue;
                FurnaceBlockEntity.serverTick((Level)world, (BlockPos)pos, (BlockState)world.getBlockState(pos), (AbstractFurnaceBlockEntity)furnace);
            }
        }
        return null;
    }

    public abstract void requestSmeltable();

    private IAIState checkIfAbleToSmelt(int amountOfFuel, int amountOfSmeltable) {
        FurnaceUserModule module = (FurnaceUserModule)this.building.getFirstModuleOccurance(FurnaceUserModule.class);
        for (BlockPos pos : module.getFurnaces()) {
            BlockEntity entity = this.world.getBlockEntity(pos);
            if (entity instanceof FurnaceBlockEntity) {
                FurnaceBlockEntity furnace = (FurnaceBlockEntity)entity;
                if (!(amountOfFuel > 0 && ItemStackUtils.hasSmeltableInFurnaceAndNoFuel(furnace) || amountOfSmeltable > 0 && ItemStackUtils.hasFuelInFurnaceAndNoSmeltable(furnace)) && (amountOfFuel <= 0 || amountOfSmeltable <= 0 || !ItemStackUtils.hasNeitherFuelNorSmeltAble(furnace))) continue;
                this.walkTo = pos;
                return AIWorkerState.START_USING_FURNACE;
            }
            if (this.world.getBlockState(pos).getBlock() instanceof FurnaceBlock) continue;
            module.removeFromFurnaces(pos);
        }
        return this.checkForAdditionalJobs();
    }

    protected IAIState checkForAdditionalJobs() {
        return AIWorkerState.START_WORKING;
    }

    protected IAIState checkForImportantJobs() {
        return AIWorkerState.START_WORKING;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1;
    }

    private IAIState retrieveSmeltableFromFurnace() {
        if (this.walkTo == null) {
            return AIWorkerState.START_WORKING;
        }
        if (!this.walkToWorkPos(this.walkTo)) {
            return this.getState();
        }
        BlockEntity entity = this.world.getBlockEntity(this.walkTo);
        if (!(entity instanceof FurnaceBlockEntity) || ItemStackUtils.isEmpty(((FurnaceBlockEntity)entity).getItem(2))) {
            this.walkTo = null;
            return AIWorkerState.START_WORKING;
        }
        this.walkTo = null;
        this.extractFromFurnace((FurnaceBlockEntity)entity);
        this.incrementActionsDoneAndDecSaturation();
        return AIWorkerState.START_WORKING;
    }

    private IAIState retrieveUsedFuel() {
        if (this.walkTo == null) {
            return AIWorkerState.START_WORKING;
        }
        if (!this.walkToWorkPos(this.walkTo)) {
            return this.getState();
        }
        BlockEntity entity = this.world.getBlockEntity(this.walkTo);
        if (!(entity instanceof FurnaceBlockEntity) || ItemStackUtils.isEmpty(((FurnaceBlockEntity)entity).getItem(1))) {
            this.walkTo = null;
            return AIWorkerState.START_WORKING;
        }
        this.walkTo = null;
        this.extractFuelFromFurnace((FurnaceBlockEntity)entity);
        return AIWorkerState.START_WORKING;
    }

    private IAIState fillUpFurnace() {
        if (((FurnaceUserModule)this.building.getFirstModuleOccurance(FurnaceUserModule.class)).getFurnaces().isEmpty()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.translatableEscape((String)"com.minecolonies.coremod.bakery.nofurnace", (Object[])new Object[0]), ChatPriority.BLOCKING));
            }
            return AIWorkerState.START_WORKING;
        }
        if (this.walkTo == null || this.world.getBlockState(this.walkTo).getBlock() != Blocks.FURNACE) {
            this.walkTo = null;
            return AIWorkerState.START_WORKING;
        }
        if (!this.walkToWorkPos(this.walkTo)) {
            return this.getState();
        }
        BlockEntity entity = this.world.getBlockEntity(this.walkTo);
        if (entity instanceof FurnaceBlockEntity) {
            FurnaceBlockEntity furnace = (FurnaceBlockEntity)entity;
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this::isSmeltable) && (ItemStackUtils.hasFuelInFurnaceAndNoSmeltable(furnace) || ItemStackUtils.hasNeitherFuelNorSmeltAble(furnace))) {
                InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this::isSmeltable, 64, (IItemHandler)new InvWrapper((Container)furnace), 0);
            }
            ItemListModule module = (ItemListModule)this.building.getModuleMatching(ItemListModule.class, m -> m.getId().equals("fuel"));
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> module.isItemInList(new ItemStorage((ItemStack)stack))) && (ItemStackUtils.hasSmeltableInFurnaceAndNoFuel(furnace) || ItemStackUtils.hasNeitherFuelNorSmeltAble(furnace))) {
                InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> module.isItemInList(new ItemStorage((ItemStack)stack)), 64, (IItemHandler)new InvWrapper((Container)furnace), 1);
            }
        }
        this.walkTo = null;
        return AIWorkerState.START_WORKING;
    }

    protected abstract IRequestable getSmeltAbleClass();
}

