/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.compatibility.jei.transfer;

import com.minecolonies.api.crafting.ModCraftingTypes;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.inventory.container.ContainerCraftingBrewingstand;
import com.minecolonies.core.client.gui.containers.WindowBrewingstandCrafting;
import com.minecolonies.core.colony.buildings.moduleviews.CraftingModuleView;
import com.minecolonies.core.compatibility.jei.JobBasedRecipeCategory;
import com.minecolonies.core.compatibility.jei.transfer.AbstractTeachingGuiHandler;
import com.minecolonies.core.network.messages.server.TransferRecipeCraftingTeachingMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BrewingCraftingGuiHandler
extends AbstractTeachingGuiHandler<WindowBrewingstandCrafting> {
    public BrewingCraftingGuiHandler(@NotNull List<JobBasedRecipeCategory<?>> categories) {
        super(categories);
    }

    @Override
    @NotNull
    protected Class<WindowBrewingstandCrafting> getWindowClass() {
        return WindowBrewingstandCrafting.class;
    }

    @NotNull
    public Collection<IGuiClickableArea> getGuiClickableAreas(@NotNull WindowBrewingstandCrafting containerScreen, double mouseX, double mouseY) {
        ArrayList<IGuiClickableArea> areas = new ArrayList<IGuiClickableArea>();
        JobBasedRecipeCategory<?> category = this.getRecipeCategory(containerScreen.getBuildingView());
        if (category != null) {
            areas.add(IGuiClickableArea.createBasic((int)34, (int)15, (int)44, (int)34, (RecipeType[])new RecipeType[]{category.getRecipeType()}));
        }
        return areas;
    }

    @Override
    protected boolean isSupportedCraftingModule(@NotNull CraftingModuleView moduleView) {
        return moduleView.canLearn((CraftingType)ModCraftingTypes.BREWING.get());
    }

    @Override
    protected boolean isSupportedSlot(@NotNull Slot slot) {
        return slot.index >= 0 && slot.index <= 3;
    }

    @Override
    protected void updateServer(@NotNull WindowBrewingstandCrafting gui) {
        HashMap<Integer, ItemStack> matrix = new HashMap<Integer, ItemStack>();
        ContainerCraftingBrewingstand inventory = (ContainerCraftingBrewingstand)gui.getMenu();
        matrix.put(0, inventory.getSlot(0).getItem());
        for (int slot = 1; slot <= 3; ++slot) {
            ItemStack container = inventory.getSlot(1).getItem();
            if (container.isEmpty()) continue;
            matrix.put(1, container);
            break;
        }
        TransferRecipeCraftingTeachingMessage message = new TransferRecipeCraftingTeachingMessage(matrix, false);
        message.sendToServer();
    }
}

