/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.colonycommands;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.commands.commandTypes.IMCOPCommand;
import com.minecolonies.core.util.BackUpHelper;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class CommandReclaimChunks
implements IMCOPCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        Entity sender = ((CommandSourceStack)context.getSource()).getEntity();
        if (!(sender instanceof Player)) {
            return 0;
        }
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        Colony colony = (Colony)IColonyManager.getInstance().getColonyByWorld(colonyID, sender.level());
        BackUpHelper.reclaimChunks(colony);
        MessageUtils.format("com.minecolonies.command.claim.success", new Object[0]).sendTo((Player)sender);
        return 1;
    }

    @Override
    public String getName() {
        return "reclaimchunks";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).executes(this::checkPreConditionAndExecute));
    }
}

