/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class CommandListColonies
implements IMCCommand {
    public static final String DESC = "list";
    private static final String ID_AND_NAME_TEXT = "ID: %s  Name: %s";
    private static final String COORDINATES_TEXT = "Coordinates: ";
    private static final String COORDINATES_XYZ = "x=%s y=%s z=%s";
    private static final String LIST_COMMAND_SUGGESTED = "/minecolonies colony list ";
    private static final String TELEPORT_COMMAND = "/minecolonies colony teleport ";
    private static final String PAGE_TOP_LEFT = "   ------------------ page ";
    private static final String PAGE_TOP_RIGHT = " ------------------";
    private static final String PAGE_TOP_MIDDLE = " of ";
    private static final String PREV_PAGE = " <- prev";
    private static final String NEXT_PAGE = "next -> ";
    private static final String PAGE_LINE = " ----------------";
    private static final String PAGE_LINE_DIVIDER = " | ";
    private static final String COMMAND_COLONY_INFO = "/minecolonies colony info %d";
    private static final int COLONIES_ON_PAGE = 9;
    public static final String START_PAGE_ARG = "startpage";

    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        return this.executeCommand(context, 1);
    }

    private int executeWithPage(CommandContext<CommandSourceStack> context) {
        if (this.checkPreCondition(context)) {
            return this.executeCommand(context, IntegerArgumentType.getInteger(context, (String)START_PAGE_ARG));
        }
        return 0;
    }

    private int executeCommand(CommandContext<CommandSourceStack> context, int startpage) {
        int page = startpage;
        List<IColony> colonies = IColonyManager.getInstance().getAllColonies();
        int colonyCount = colonies.size();
        int halfPage = colonyCount % 9 == 0 ? 0 : 1;
        int pageCount = (int)(Math.floor((double)colonyCount / 9.0) + (double)halfPage);
        if (page < 1 || page > pageCount) {
            page = 1;
        }
        int pageStartIndex = 9 * (page - 1);
        int pageStopIndex = Math.min(9 * page, colonyCount);
        int prevPage = Math.max(1, page - 1);
        int nextPage = Math.min(page + 1, colonyCount / 9 + halfPage);
        List<Object> coloniesPage = pageStartIndex < 0 || pageStartIndex >= colonyCount ? new ArrayList() : colonies.subList(pageStartIndex, pageStopIndex);
        MutableComponent headerLine = Component.literal((String)(PAGE_TOP_LEFT + page + PAGE_TOP_MIDDLE + pageCount + PAGE_TOP_RIGHT));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandListColonies.lambda$executeCommand$0((Component)headerLine), true);
        for (IColony iColony : coloniesPage) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)(String.format(ID_AND_NAME_TEXT, colony.getID(), colony.getName()) + " Mayor: " + colony.getPermissions().getOwnerName())).setStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(COMMAND_COLONY_INFO, colony.getID())))), true);
            BlockPos center = iColony.getCenter();
            MutableComponent teleport = Component.literal((String)("Citizens:" + iColony.getCitizenManager().getCurrentCitizenCount() + " ")).append((Component)Component.literal((String)(COORDINATES_TEXT + String.format(COORDINATES_XYZ, center.getX(), center.getY(), center.getZ()))).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.GOLD).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, TELEPORT_COMMAND + iColony.getID()))));
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> teleport, true);
        }
        MutableComponent prevButton = Component.literal((String)PREV_PAGE).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.GOLD).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, LIST_COMMAND_SUGGESTED + prevPage)));
        MutableComponent mutableComponent = Component.literal((String)NEXT_PAGE).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.GOLD).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, LIST_COMMAND_SUGGESTED + nextPage)));
        MutableComponent beginLine = Component.literal((String)PAGE_LINE);
        MutableComponent endLine = Component.literal((String)PAGE_LINE);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandListColonies.lambda$executeCommand$3(beginLine, (Component)prevButton, (Component)mutableComponent, endLine), true);
        return 1;
    }

    @Override
    public String getName() {
        return DESC;
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument(START_PAGE_ARG, IntegerArgumentType.integer((int)1)).executes(this::executeWithPage))).executes(this::checkPreConditionAndExecute);
    }

    private static /* synthetic */ Component lambda$executeCommand$3(MutableComponent beginLine, Component prevButton, Component nextButton, MutableComponent endLine) {
        return beginLine.append(prevButton).append((Component)Component.literal((String)PAGE_LINE_DIVIDER)).append(nextButton).append((Component)endLine);
    }

    private static /* synthetic */ Component lambda$executeCommand$0(Component headerLine) {
        return headerLine;
    }
}

