/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.colony.events.raid.RaidManager;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.commands.commandTypes.IMCOPCommand;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class CommandColonyRaidsInfo
implements IMCOPCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (ResourceKey<Level>)((CommandSourceStack)context.getSource()).getLevel().dimension());
        if (colony == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), true);
            return 0;
        }
        if (!((CommandSourceStack)context.getSource()).hasPermission(4) && !((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).canPlayerUseShowColonyInfoCommand.get()).booleanValue()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.notenabledinconfig", (Object[])new Object[0]), true);
            return 0;
        }
        List<RaidManager.RaidHistory> allRaids = ((RaidManager)colony.getRaiderManager()).getAllRaids();
        for (int i = 0; i < allRaids.size(); ++i) {
            RaidManager.RaidHistory history = allRaids.get(i);
            double hoursSince = (double)Math.round((double)(100L * (colony.getWorld().getGameTime() - history.raidTime)) / 72000.0) / 100.0;
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)(hoursSince + " hours ago:" + String.valueOf(history))), true);
        }
        return 1;
    }

    @Override
    public String getName() {
        return "raidhistory";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).executes(this::checkPreConditionAndExecute));
    }
}

