/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.workorders.view;

import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.workorders.IWorkOrderView;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.util.ColonyUtils;
import com.minecolonies.api.util.constant.Constants;
import com.minecolonies.core.entity.ai.workers.util.BuildingProgressStage;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWorkOrderView
implements IWorkOrderView {
    private int id;
    private int priority;
    private BlockPos claimedBy;
    private String packName;
    private String structurePath;
    private WorkOrderType workOrderType;
    private BlockPos location;
    private RotationMirror rotationMirror;
    private int currentLevel;
    private int targetLevel;
    private BuildingProgressStage stage = null;
    private String translationKey;
    protected AABB box = Constants.EMPTY_AABB;
    protected Blueprint blueprint = null;
    protected IColony colony = null;
    protected CompletableFuture<Blueprint> future = null;

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void setID(int id) {
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public BlockPos getClaimedBy() {
        return this.claimedBy;
    }

    @Override
    public void setClaimedBy(BlockPos position) {
        this.claimedBy = position;
    }

    @Override
    public void setBlueprint(Blueprint blueprint, Level world) {
        if (blueprint != null) {
            this.blueprint = blueprint;
            blueprint.setRotationMirror(this.getRotationMirror(), world);
        }
    }

    @Override
    public Blueprint getBlueprint() {
        return this.blueprint;
    }

    @Override
    public void clearBlueprint() {
        this.blueprint = null;
        this.future = null;
    }

    @Override
    public AABB getBoundingBox() {
        return this.box;
    }

    @Override
    public IColony getColony() {
        return this.colony;
    }

    @Override
    public void setColony(IColony colony) {
        this.colony = colony;
    }

    @Override
    public BuildingProgressStage getStage() {
        return this.stage;
    }

    @Override
    public String getStructurePack() {
        return this.packName.replaceAll("schematics/(?:decorations/)?", "");
    }

    @Override
    public void loadBlueprint(Level world, Consumer<Blueprint> afterLoad) {
        if (this.blueprint != null) {
            afterLoad.accept(this.blueprint);
        } else if (this.future == null || this.future.isDone()) {
            this.future = ColonyUtils.queueBlueprintLoad(world, this.getStructurePack(), this.getStructurePath(), blueprint -> {
                this.setBlueprint((Blueprint)blueprint, world);
                afterLoad.accept((Blueprint)blueprint);
            }, e -> afterLoad.accept(null));
        } else {
            afterLoad.accept(null);
        }
    }

    @Override
    public String getStructurePath() {
        return this.structurePath;
    }

    @Override
    public final String getTranslationKey() {
        return this.translationKey;
    }

    @Override
    public WorkOrderType getWorkOrderType() {
        return this.workOrderType;
    }

    @Override
    public BlockPos getLocation() {
        return this.location;
    }

    @Override
    public RotationMirror getRotationMirror() {
        return this.rotationMirror;
    }

    @Override
    public boolean isClaimed() {
        return !BlockPos.ZERO.equals((Object)this.claimedBy);
    }

    @Override
    public int getCurrentLevel() {
        return this.currentLevel;
    }

    @Override
    public int getTargetLevel() {
        return this.targetLevel;
    }

    @Override
    public void deserialize(@NotNull RegistryFriendlyByteBuf buf) {
        this.id = buf.readInt();
        this.priority = buf.readInt();
        this.claimedBy = buf.readBlockPos();
        this.packName = buf.readUtf(Short.MAX_VALUE);
        this.structurePath = buf.readUtf(Short.MAX_VALUE);
        this.translationKey = buf.readUtf(Short.MAX_VALUE);
        this.workOrderType = WorkOrderType.values()[buf.readInt()];
        this.location = buf.readBlockPos();
        this.rotationMirror = RotationMirror.values()[buf.readByte()];
        this.currentLevel = buf.readInt();
        this.targetLevel = buf.readInt();
        this.stage = BuildingProgressStage.values()[buf.readInt()];
        this.box = new AABB(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    @Override
    public boolean canBuildIgnoringDistance(@NotNull BlockPos builderLocation, int builderLevel) {
        return builderLevel >= this.targetLevel || builderLevel == 5 || builderLocation.equals((Object)this.location);
    }
}

