/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.jobs;

import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.workorders.IBuilderWorkOrder;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.core.colony.jobs.AbstractJob;
import com.minecolonies.core.entity.ai.workers.AbstractAISkeleton;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJobStructure<AI extends AbstractAISkeleton<J>, J extends AbstractJobStructure<AI, J>>
extends AbstractJob<AI, J> {
    private static final String TAG_WORK_ORDER = "workorder";
    private int workOrderId;

    public AbstractJobStructure(ICitizenData entity) {
        super(entity);
    }

    public int getWorkOrderId() {
        return this.workOrderId;
    }

    public boolean hasWorkOrder() {
        if (this.workOrderId == 0 || this.getWorkOrder() == null) {
            this.workOrderId = 0;
            return false;
        }
        return true;
    }

    @Override
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        if (this.workOrderId != 0) {
            compound.putInt(TAG_WORK_ORDER, this.workOrderId);
        }
        return compound;
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        super.deserializeNBT(provider, compound);
        if (compound.contains(TAG_WORK_ORDER)) {
            this.workOrderId = compound.getInt(TAG_WORK_ORDER);
        }
    }

    public void complete() {
        this.getWorkOrder().onCompleted(this.getCitizen().getColony(), this.getCitizen());
        Blueprint blueprint = this.getWorkOrder().getBlueprint();
        if (blueprint != null) {
            CompoundTag[][][] tileEntityData = blueprint.getTileEntities();
            for (short x = 0; x < blueprint.getSizeX(); x = (short)((short)(x + 1))) {
                for (short y = 0; y < blueprint.getSizeY(); y = (short)(y + 1)) {
                    for (short z = 0; z < blueprint.getSizeZ(); z = (short)((short)(z + 1))) {
                        CompoundTag compoundNBT = tileEntityData[y][z][x];
                        if (compoundNBT == null || !compoundNBT.contains("blueprintDataProvider")) continue;
                        BlockPos tePos = this.getWorkOrder().getLocation().subtract((Vec3i)blueprint.getPrimaryBlockOffset()).offset((int)x, (int)y, (int)z);
                        BlockEntity te = this.getColony().getWorld().getBlockEntity(tePos);
                        if (!(te instanceof IBlueprintDataProviderBE)) continue;
                        CompoundTag tagData = compoundNBT.getCompound("blueprintDataProvider");
                        String schematicPath = tagData.getString("name");
                        String location = StructurePacks.getStructurePack((String)blueprint.getPackName()).getSubPath(Utils.resolvePath(blueprint.getFilePath(), schematicPath));
                        tagData.putString("name", location);
                        tagData.putString("pack", blueprint.getPackName());
                        try {
                            ((IBlueprintDataProviderBE)te).readSchematicDataFromNBT(compoundNBT);
                        }
                        catch (Exception e) {
                            Log.getLogger().warn("Broken deco-controller at: " + x + " " + y + " " + z);
                        }
                        ((ServerLevel)this.getColony().getWorld()).getChunkSource().blockChanged(tePos);
                        te.setChanged();
                    }
                }
            }
        }
        this.getCitizen().getColony().getWorkManager().removeWorkOrder(this.workOrderId);
        this.setWorkOrder(null);
    }

    public IBuilderWorkOrder getWorkOrder() {
        return this.getColony().getWorkManager().getWorkOrder(this.workOrderId, IBuilderWorkOrder.class);
    }

    private void resetNeededItems() {
        IBuilding workerBuilding = this.getCitizen().getWorkBuilding();
        if (workerBuilding instanceof AbstractBuildingStructureBuilder) {
            ((AbstractBuildingStructureBuilder)workerBuilding).resetNeededResources();
        }
    }

    public void setWorkOrder(@Nullable IWorkOrder order) {
        if (order == null) {
            this.workOrderId = 0;
            this.resetNeededItems();
        } else {
            this.workOrderId = order.getID();
        }
    }
}

