/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.interactionhandling;

import com.ldtteam.structurize.api.BlockPosUtil;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.interactionhandling.IChatPriority;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.colony.interactionhandling.InteractionValidatorRegistry;
import com.minecolonies.api.colony.interactionhandling.ModInteractionResponseHandlers;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.interactionhandling.ServerCitizenInteraction;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class PosBasedInteraction
extends ServerCitizenInteraction {
    private static final String POS_TAG = "pos";
    private static final Tuple<Component, Component>[] responses = new Tuple[]{new Tuple<MutableComponent, MutableComponent>(Component.translatableEscape((String)"com.minecolonies.coremod.gui.chat.okay", (Object[])new Object[0]), Component.empty()), new Tuple<MutableComponent, MutableComponent>(Component.translatableEscape((String)"com.minecolonies.coremod.gui.chat.ignore", (Object[])new Object[0]), Component.empty()), new Tuple<MutableComponent, MutableComponent>(Component.translatableEscape((String)"com.minecolonies.coremod.gui.chat.remindmelater", (Object[])new Object[0]), Component.empty()), new Tuple<MutableComponent, MutableComponent>(Component.translatableEscape((String)"com.minecolonies.coremod.gui.chat.skipchitchat", (Object[])new Object[0]), Component.empty())};
    private BlockPos pos = null;
    private BiPredicate<ICitizenData, BlockPos> validator;

    public PosBasedInteraction(Component inquiry, IChatPriority priority, Component validator, BlockPos pos) {
        super(inquiry, true, priority, null, validator, responses);
        this.validator = InteractionValidatorRegistry.getPosBasedInteractionValidatorPredicate(validator);
        this.pos = pos;
    }

    public PosBasedInteraction(Component inquiry, IChatPriority priority, BlockPos pos) {
        super(inquiry, true, priority, null, inquiry, responses);
        this.validator = InteractionValidatorRegistry.getPosBasedInteractionValidatorPredicate(inquiry);
        this.pos = pos;
    }

    public PosBasedInteraction(ICitizen data) {
        super(data);
    }

    @Override
    public List<IInteractionResponseHandler> genChildInteractions() {
        return Collections.emptyList();
    }

    @Override
    public boolean isValid(ICitizenData citizen) {
        if (this.pos != null && !WorldUtil.isBlockLoaded((LevelAccessor)citizen.getColony().getWorld(), this.pos)) {
            return true;
        }
        return this.validator == null && !this.parents.isEmpty() || this.validator != null && this.validator.test(citizen, this.pos);
    }

    @Override
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.serializeNBT(provider);
        BlockPosUtil.writeToNBT((CompoundTag)tag, (String)POS_TAG, (BlockPos)this.pos);
        return tag;
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compoundNBT) {
        super.deserializeNBT(provider, compoundNBT);
        this.pos = BlockPosUtil.readFromNBT((CompoundTag)compoundNBT, (String)POS_TAG);
    }

    @Override
    protected void loadValidator() {
        this.validator = InteractionValidatorRegistry.getPosBasedInteractionValidatorPredicate(this.validatorId);
    }

    @Override
    public String getType() {
        return ModInteractionResponseHandlers.POS.getPath();
    }
}

