/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.events.raid.norsemenevent;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesRaider;
import com.minecolonies.core.colony.events.raid.HordeRaidEvent;
import com.minecolonies.core.entity.mobs.raider.norsemen.EntityNorsemenArcherRaider;
import com.minecolonies.core.entity.mobs.raider.norsemen.EntityNorsemenChiefRaider;
import com.minecolonies.core.entity.mobs.raider.norsemen.EntityShieldmaidenRaider;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class NorsemenRaidEvent
extends HordeRaidEvent {
    public static final ResourceLocation NORSEMEN_RAID_EVENT_TYPE_ID = new ResourceLocation("minecolonies", "norsemen_raid");

    public NorsemenRaidEvent(IColony colony) {
        super(colony);
    }

    @Override
    public ResourceLocation getEventTypeID() {
        return NORSEMEN_RAID_EVENT_TYPE_ID;
    }

    @Override
    protected void updateRaidBar() {
        super.updateRaidBar();
        this.raidBar.setCreateWorldFog(true);
    }

    @Override
    public void registerEntity(Entity entity) {
        if (!(entity instanceof AbstractEntityMinecoloniesRaider) || !entity.isAlive()) {
            entity.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (entity instanceof EntityNorsemenChiefRaider && this.boss.keySet().size() < this.horde.numberOfBosses) {
            this.boss.put(entity, entity.getUUID());
            return;
        }
        if (entity instanceof EntityNorsemenArcherRaider && this.archers.keySet().size() < this.horde.numberOfArchers) {
            this.archers.put(entity, entity.getUUID());
            return;
        }
        if (entity instanceof EntityShieldmaidenRaider && this.normal.keySet().size() < this.horde.numberOfRaiders) {
            this.normal.put(entity, entity.getUUID());
            return;
        }
        entity.remove(Entity.RemovalReason.DISCARDED);
    }

    @Override
    public void onEntityDeath(LivingEntity entity) {
        super.onEntityDeath(entity);
        if (!(entity instanceof AbstractEntityMinecoloniesRaider)) {
            return;
        }
        if (entity instanceof EntityNorsemenChiefRaider) {
            this.boss.remove(entity);
            --this.horde.numberOfBosses;
        }
        if (entity instanceof EntityNorsemenArcherRaider) {
            this.archers.remove(entity);
            --this.horde.numberOfArchers;
        }
        if (entity instanceof EntityShieldmaidenRaider) {
            this.normal.remove(entity);
            --this.horde.numberOfRaiders;
        }
        --this.horde.hordeSize;
        if (this.horde.hordeSize == 0) {
            this.status = EventStatus.DONE;
        }
        this.sendHordeMessage();
    }

    public static NorsemenRaidEvent loadFromNBT(IColony colony, CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        NorsemenRaidEvent event = new NorsemenRaidEvent(colony);
        event.deserializeNBT(provider, compound);
        return event;
    }

    @Override
    public EntityType<?> getNormalRaiderType() {
        return ModEntities.SHIELDMAIDEN;
    }

    @Override
    public EntityType<?> getArcherRaiderType() {
        return ModEntities.NORSEMEN_ARCHER;
    }

    @Override
    public EntityType<?> getBossRaiderType() {
        return ModEntities.NORSEMEN_CHIEF;
    }

    @Override
    protected MutableComponent getDisplayName() {
        return Component.translatableEscape((String)"com.minecolonies.coremod.raid.norsemen.name", (Object[])new Object[0]);
    }
}

