/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.events.raid.amazonevent;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesRaider;
import com.minecolonies.api.sounds.RaidSounds;
import com.minecolonies.core.colony.events.raid.HordeRaidEvent;
import com.minecolonies.core.entity.mobs.raider.amazons.EntityAmazonChiefRaider;
import com.minecolonies.core.entity.mobs.raider.amazons.EntityAmazonSpearmanRaider;
import com.minecolonies.core.entity.mobs.raider.amazons.EntityArcherAmazonRaider;
import com.minecolonies.core.network.messages.client.PlayAudioMessage;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class AmazonRaidEvent
extends HordeRaidEvent {
    public static final ResourceLocation AMAZON_RAID_EVENT_TYPE_ID = new ResourceLocation("minecolonies", "amazon_raid");
    private int musicCooldown = 0;

    public AmazonRaidEvent(IColony colony) {
        super(colony);
    }

    @Override
    public ResourceLocation getEventTypeID() {
        return AMAZON_RAID_EVENT_TYPE_ID;
    }

    @Override
    public void registerEntity(Entity entity) {
        if (!(entity instanceof AbstractEntityMinecoloniesRaider) || !entity.isAlive()) {
            entity.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (entity instanceof EntityAmazonChiefRaider && this.boss.keySet().size() < this.horde.numberOfBosses) {
            this.boss.put(entity, entity.getUUID());
            return;
        }
        if (entity instanceof EntityArcherAmazonRaider && this.archers.keySet().size() < this.horde.numberOfArchers) {
            this.archers.put(entity, entity.getUUID());
            return;
        }
        if (entity instanceof EntityAmazonSpearmanRaider && this.normal.keySet().size() < this.horde.numberOfRaiders) {
            this.normal.put(entity, entity.getUUID());
            return;
        }
        entity.remove(Entity.RemovalReason.DISCARDED);
    }

    @Override
    protected void updateRaidBar() {
        super.updateRaidBar();
        this.raidBar.setCreateWorldFog(true);
    }

    @Override
    protected MutableComponent getDisplayName() {
        return Component.translatableEscape((String)"com.minecolonies.coremod.raid.amazon.name", (Object[])new Object[0]);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (--this.musicCooldown <= 0) {
            PlayAudioMessage.sendToAll(this.getColony(), true, true, new PlayAudioMessage(RaidSounds.AMAZON_RAID));
            this.musicCooldown = 20;
        }
    }

    @Override
    public void onEntityDeath(LivingEntity entity) {
        super.onEntityDeath(entity);
        if (!(entity instanceof AbstractEntityMinecoloniesRaider)) {
            return;
        }
        if (entity instanceof EntityAmazonChiefRaider) {
            this.boss.remove(entity);
            --this.horde.numberOfBosses;
        }
        if (entity instanceof EntityArcherAmazonRaider) {
            this.archers.remove(entity);
            --this.horde.numberOfArchers;
        }
        if (entity instanceof EntityAmazonSpearmanRaider) {
            this.normal.remove(entity);
            --this.horde.numberOfRaiders;
        }
        --this.horde.hordeSize;
        if (this.horde.hordeSize == 0) {
            this.status = EventStatus.DONE;
        }
        this.sendHordeMessage();
    }

    public static AmazonRaidEvent loadFromNBT(IColony colony, CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        AmazonRaidEvent event = new AmazonRaidEvent(colony);
        event.deserializeNBT(provider, compound);
        return event;
    }

    @Override
    public EntityType<?> getNormalRaiderType() {
        return ModEntities.AMAZONSPEARMAN;
    }

    @Override
    public EntityType<?> getArcherRaiderType() {
        return ModEntities.AMAZON;
    }

    @Override
    public EntityType<?> getBossRaiderType() {
        return ModEntities.AMAZONCHIEF;
    }
}

