/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IEntityListModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class EntityListModule
extends AbstractBuildingModule
implements IEntityListModule,
IPersistentModule {
    private static final String TAG_MOBLIST = "newmoblist";
    private final Set<ResourceLocation> mobsAllowed = new HashSet<ResourceLocation>();
    private final String id;

    public EntityListModule(String id) {
        this.id = id;
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        if (compound.contains(this.id)) {
            compound = compound.getCompound(this.id);
        }
        ListTag filterableList = compound.getList(TAG_MOBLIST, 8);
        for (int i = 0; i < filterableList.size(); ++i) {
            ResourceLocation res = ResourceLocation.parse((String)filterableList.getString(i));
            if (!BuiltInRegistries.ENTITY_TYPE.containsKey(res)) continue;
            this.mobsAllowed.add(res);
        }
    }

    @Override
    public void serializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        @NotNull ListTag filteredMobs = new ListTag();
        for (ResourceLocation mob : this.mobsAllowed) {
            filteredMobs.add((Object)StringTag.valueOf((String)mob.toString()));
        }
        compound.put(TAG_MOBLIST, (Tag)filteredMobs);
    }

    @Override
    public void addEntity(ResourceLocation item) {
        this.mobsAllowed.add(item);
        this.markDirty();
    }

    @Override
    public boolean isEntityInList(ResourceLocation entity) {
        return this.mobsAllowed.contains(entity);
    }

    @Override
    public void removeEntity(ResourceLocation item) {
        this.mobsAllowed.remove(item);
        this.markDirty();
    }

    public ImmutableList<ResourceLocation> getList() {
        return ImmutableList.copyOf(this.mobsAllowed);
    }

    @Override
    public String getListIdentifier() {
        return this.id;
    }

    @Override
    public void serializeToView(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.mobsAllowed.size());
        for (ResourceLocation entity : this.mobsAllowed) {
            buf.writeResourceLocation(entity);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }
}

