/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.IAssignsJob;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ITickingModule;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.core.colony.buildings.modules.AbstractAssignedCitizenModule;
import com.minecolonies.core.colony.jobs.JobDeliveryman;
import com.minecolonies.core.util.BuildingUtils;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;

public class CourierAssignmentModule
extends AbstractAssignedCitizenModule
implements IAssignsJob,
IBuildingEventsModule,
ITickingModule,
IPersistentModule {
    @Override
    public void onColonyTick(@NotNull IColony colony) {
        if (!this.isFull() && BuildingUtils.canAutoHire(this.building, this.getHiringMode(), this.getJobEntry())) {
            for (ICitizenData data : colony.getCitizenManager().getCitizens()) {
                if (!(data.getJob() instanceof JobDeliveryman) || this.hasAssignedCitizen(data) || ((JobDeliveryman)data.getJob()).findWareHouse() != null) continue;
                this.assignCitizen(data);
            }
        }
        for (ICitizenData citizenData : new ArrayList<ICitizenData>(this.getAssignedCitizen())) {
            if (citizenData.getJob() instanceof JobDeliveryman) continue;
            this.removeCitizen(citizenData);
        }
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        int[] residentIds;
        super.deserializeNBT(provider, compound);
        if (compound.contains(this.getModuleSerializationIdentifier())) {
            compound = compound.getCompound(this.getModuleSerializationIdentifier());
        }
        for (int citizenId : residentIds = compound.getIntArray("couriers")) {
            ICitizenData citizen = this.building.getColony().getCitizenManager().getCivilian(citizenId);
            if (citizen == null) continue;
            this.assignCitizen(citizen);
        }
    }

    @Override
    public void serializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        super.serializeNBT(provider, compound);
        if (!this.assignedCitizen.isEmpty()) {
            int[] residentIds = new int[this.assignedCitizen.size()];
            for (int i = 0; i < this.assignedCitizen.size(); ++i) {
                residentIds[i] = ((ICitizenData)this.assignedCitizen.get(i)).getId();
            }
            compound.putIntArray("couriers", residentIds);
        }
    }

    @Override
    public void onRemoval(ICitizenData citizen) {
    }

    @Override
    public void onAssignment(ICitizenData citizen) {
    }

    @Override
    public int getModuleMax() {
        return this.building.getBuildingLevel() * 2;
    }

    @Override
    public JobEntry getJobEntry() {
        return (JobEntry)ModJobs.delivery.get();
    }

    @Override
    protected String getModuleSerializationIdentifier() {
        return "warehouse";
    }
}

