/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules;

import com.minecolonies.api.colony.buildingextensions.IBuildingExtension;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BuildingExtensionsModule
extends AbstractBuildingModule
implements IPersistentModule,
IBuildingModule {
    private static final String TAG_ASSIGN_MANUALLY = "assign";
    private static final String TAG_CURRENT_EXTENSION = "currex";
    private final Map<IBuildingExtension.ExtensionId, Integer> checkedExtensions = new Object2IntOpenHashMap();
    @Nullable
    private IBuildingExtension.ExtensionId currentExtensionId;
    private boolean shouldAssignManually = false;

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        this.shouldAssignManually = compound.getBoolean(TAG_ASSIGN_MANUALLY);
        ListTag listTag = compound.getList("building_extensions", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag tag = listTag.getCompound(i);
            this.checkedExtensions.put(IBuildingExtension.ExtensionId.deserializeNBT(provider, tag.getCompound("id")), compound.getInt("day"));
        }
        if (compound.contains(TAG_CURRENT_EXTENSION)) {
            this.currentExtensionId = IBuildingExtension.ExtensionId.deserializeNBT(provider, compound.getCompound(TAG_CURRENT_EXTENSION));
        }
    }

    @Override
    public void serializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        compound.putBoolean(TAG_ASSIGN_MANUALLY, this.shouldAssignManually);
        ListTag listTag = new ListTag();
        for (Map.Entry<IBuildingExtension.ExtensionId, Integer> entry : this.checkedExtensions.entrySet()) {
            CompoundTag listEntry = new CompoundTag();
            compound.put("id", entry.getKey().serializeNBT(provider));
            listEntry.putLong("day", (long)entry.getValue().intValue());
            listTag.add((Object)listEntry);
        }
        compound.put("List", (Tag)listTag);
        if (this.currentExtensionId != null) {
            compound.put(TAG_CURRENT_EXTENSION, this.currentExtensionId.serializeNBT(provider));
        }
    }

    @Override
    public void serializeToView(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeBoolean(this.shouldAssignManually);
        buf.writeInt(this.getMaxExtensionCount());
    }

    protected abstract int getMaxExtensionCount();

    public abstract Class<?> getExpectedExtensionType();

    @Nullable
    public IBuildingExtension getCurrentExtension() {
        if (this.currentExtensionId == null) {
            return null;
        }
        return this.building.getColony().getBuildingManager().getMatchingBuildingExtension(this.currentExtensionId);
    }

    @Nullable
    public IBuildingExtension getBuildingExtensionToWorkOn() {
        IBuildingExtension currentExtension = this.getCurrentExtension();
        if (currentExtension != null) {
            return currentExtension;
        }
        IBuildingExtension.ExtensionId lastUsedExtension = null;
        int lastUsedExtensionDay = this.building.getColony().getDay();
        for (IBuildingExtension extension : this.getOwnedExtensions()) {
            if (!this.checkedExtensions.containsKey(extension.getId())) {
                this.currentExtensionId = extension.getId();
                return extension;
            }
            int lastDay = this.checkedExtensions.get(extension.getId());
            if (lastDay >= lastUsedExtensionDay) continue;
            lastUsedExtension = extension.getId();
            lastUsedExtensionDay = lastDay;
        }
        this.currentExtensionId = lastUsedExtension;
        return this.getCurrentExtension();
    }

    @NotNull
    public final List<IBuildingExtension> getOwnedExtensions() {
        return this.getMatchingExtension(f -> this.building.getID().equals((Object)f.getBuildingId()));
    }

    @NotNull
    public abstract List<IBuildingExtension> getMatchingExtension(Predicate<IBuildingExtension> var1);

    public void claimExtensions() {
        if (!this.shouldAssignManually) {
            for (IBuildingExtension extension : this.getFreeExtensions()) {
                this.assignExtension(extension);
            }
        }
    }

    public final List<IBuildingExtension> getFreeExtensions() {
        return this.getMatchingExtension(extension -> !extension.isTaken());
    }

    public void assignExtension(IBuildingExtension extension) {
        if (this.canAssignExtension(extension)) {
            extension.setBuilding(this.building.getID());
            this.markDirty();
        }
    }

    public final boolean canAssignExtension(IBuildingExtension extension) {
        return this.getOwnedExtensions().size() < this.getMaxExtensionCount() && this.canAssignExtensionOverride(extension);
    }

    @Override
    public void markDirty() {
        super.markDirty();
        this.building.getColony().getBuildingManager().markBuildingExtensionsDirty();
    }

    protected abstract boolean canAssignExtensionOverride(IBuildingExtension var1);

    public final boolean assignManually() {
        return this.shouldAssignManually;
    }

    public final boolean hasNoExtensions() {
        return this.getOwnedExtensions().isEmpty();
    }

    public final void setAssignManually(boolean assignManually) {
        this.shouldAssignManually = assignManually;
    }

    public void freeExtension(IBuildingExtension extension) {
        extension.resetOwningBuilding();
        this.markDirty();
        if (this.currentExtensionId == extension.getId()) {
            this.resetCurrentExtension();
        }
    }

    public void resetCurrentExtension() {
        if (this.currentExtensionId != null) {
            this.checkedExtensions.put(this.currentExtensionId, this.building.getColony().getDay());
        }
        this.currentExtensionId = null;
    }
}

