/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render.worldevent;

import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.items.component.BuildingId;
import com.minecolonies.core.client.render.worldevent.WorldEventContext;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;

public class ColonyPatrolPointRenderer {
    private static BlueprintPreviewData partolPointTemplate;
    private static Future<Blueprint> pendingTemplate;

    static void render(WorldEventContext ctx) {
        if (ctx.mainHandItem.getItem() != ModItems.scepterGuard) {
            return;
        }
        IBuildingView guardTowerView = BuildingId.readBuildingViewFromItemStack(ctx.mainHandItem);
        if (guardTowerView == null) {
            return;
        }
        if (pendingTemplate == null && partolPointTemplate == null) {
            pendingTemplate = StructurePacks.getBlueprintFuture((String)"Minecolonies Original", (String)"infrastructure/misc/patrolpoint.blueprint", (HolderLookup.Provider)ctx.clientLevel.registryAccess());
            return;
        }
        if (pendingTemplate != null && pendingTemplate.isDone()) {
            try {
                BlueprintPreviewData tempPreviewData = new BlueprintPreviewData();
                tempPreviewData.setBlueprint(pendingTemplate.get());
                tempPreviewData.setPos(BlockPos.ZERO);
                partolPointTemplate = tempPreviewData;
                pendingTemplate = null;
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            return;
        }
        if (guardTowerView instanceof AbstractBuildingGuards.View) {
            AbstractBuildingGuards.View guardTower = (AbstractBuildingGuards.View)guardTowerView;
            ctx.renderBlueprint(partolPointTemplate, guardTower.getPatrolTargets());
        }
    }
}

