/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render.worldevent;

import com.ldtteam.blockui.util.color.ColourARGB;
import com.ldtteam.blockui.util.color.ColourQuartet;
import com.ldtteam.blockui.util.color.ColouredVertexConsumer;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.util.WorldRenderMacros;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.claim.IChunkClaimData;
import com.minecolonies.api.configuration.ClientConfiguration;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.client.render.worldevent.WorldEventContext;
import com.minecolonies.core.util.MutableChunkPos;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;

public class ColonyBorderRenderer {
    private static final int RENDER_DIST_THRESHOLD = 3;
    private static final int CHUNK_SIZE = 16;
    private static final int PLAYER_CHUNK_STEP = 4;
    private static VertexBuffer colonies = null;
    private static VertexBuffer chunktickets = null;
    private static ChunkPos lastPlayerChunkPos = null;
    private static IColonyView lastColony = null;

    static void render(WorldEventContext ctx) {
        VertexBuffer p;
        if (ctx.mainHandItem.getItem() != ModItems.buildTool.get() || !ctx.hasNearestColony()) {
            return;
        }
        ChunkPos playerChunkPos = new ChunkPos(ctx.clientPlayer.blockPosition());
        if (lastColony != ctx.nearestColony || !lastPlayerChunkPos.equals((Object)playerChunkPos)) {
            lastColony = ctx.nearestColony;
            lastPlayerChunkPos = playerChunkPos;
            HashMap<ChunkPos, Integer> coloniesMap = new HashMap<ChunkPos, Integer>();
            HashMap<ChunkPos, Integer> chunkticketsMap = new HashMap<ChunkPos, Integer>();
            int nearestColonyId = ctx.nearestColony.getID();
            int playerRenderDist = Math.max(ctx.clientRenderDist - 3, 2);
            int range = Math.max(ctx.clientRenderDist, (Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).maxColonySize.get());
            for (int chunkX = -range; chunkX <= range; ++chunkX) {
                for (int chunkZ = -range; chunkZ <= range; ++chunkZ) {
                    LevelChunk chunk = ctx.clientLevel.getChunk(playerChunkPos.x + chunkX, playerChunkPos.z + chunkZ);
                    if (chunk.isEmpty()) continue;
                    ChunkPos chunkPos = chunk.getPos();
                    IChunkClaimData cap = IColonyManager.getInstance().getClaimData(ctx.nearestColony.getDimension(), chunkPos);
                    if (cap != null) {
                        coloniesMap.put(chunkPos, cap.getOwningColony());
                    }
                    if (ctx.nearestColony.getTicketedChunks().contains(chunkPos.toLong())) {
                        chunkticketsMap.put(chunkPos, nearestColonyId);
                        continue;
                    }
                    chunkticketsMap.put(chunkPos, 0);
                }
            }
            if (colonies != null) {
                colonies.close();
            }
            if (chunktickets != null) {
                chunktickets.close();
            }
            colonies = ColonyBorderRenderer.draw(ctx, coloniesMap, nearestColonyId, playerChunkPos, playerRenderDist);
            chunktickets = ColonyBorderRenderer.draw(ctx, chunkticketsMap, nearestColonyId, playerChunkPos, playerRenderDist);
        }
        VertexBuffer vertexBuffer = p = Screen.hasControlDown() ? chunktickets : colonies;
        if (p == null) {
            return;
        }
        ctx.pushPoseCameraToPos(lastPlayerChunkPos.getWorldPosition());
        ctx.pushShaderMvMatrixFromPose();
        WorldRenderMacros.LINES.setupRenderState();
        p.bind();
        p.drawWithShader(RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix(), GameRenderer.getPositionColorShader());
        VertexBuffer.unbind();
        WorldRenderMacros.LINES.clearRenderState();
        ctx.popShaderMvMatrix();
        ctx.popPose();
    }

    private static VertexBuffer draw(WorldEventContext ctx, Map<ChunkPos, Integer> mapToDraw, int playerColonyId, ChunkPos playerChunkPos, int playerRenderDist) {
        MutableChunkPos mutableChunkPos = new MutableChunkPos(0, 0);
        HashMap colonyColours = new HashMap();
        boolean useColonyColour = (Boolean)((ClientConfiguration)IMinecoloniesAPI.getInstance().getConfig().getClient()).colonyteamborders.get();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(WorldRenderMacros.LINES.mode(), WorldRenderMacros.LINES.format());
        ColouredVertexConsumer buf = new ColouredVertexConsumer((VertexConsumer)bufferbuilder);
        mapToDraw.forEach((chunkPos, colonyId) -> {
            block28: {
                int y;
                int shift;
                boolean west;
                if (colonyId == 0 || chunkPos.x <= playerChunkPos.x - playerRenderDist || chunkPos.x >= playerChunkPos.x + playerRenderDist || chunkPos.z <= playerChunkPos.z - playerRenderDist || chunkPos.z >= playerChunkPos.z + playerRenderDist) {
                    return;
                }
                boolean isPlayerChunkX = colonyId == playerColonyId && chunkPos.x == playerChunkPos.x;
                boolean isPlayerChunkZ = colonyId == playerColonyId && chunkPos.z == playerChunkPos.z;
                float minX = chunkPos.getMinBlockX() - playerChunkPos.getMinBlockX();
                float maxX = (float)(chunkPos.getMaxBlockX() - playerChunkPos.getMinBlockX()) + 1.0f;
                float minZ = chunkPos.getMinBlockZ() - playerChunkPos.getMinBlockZ();
                float maxZ = (float)(chunkPos.getMaxBlockZ() - playerChunkPos.getMinBlockZ()) + 1.0f;
                int minY = ctx.clientLevel.getMinBuildHeight();
                int maxY = ctx.clientLevel.getMaxBuildHeight();
                int testedColonyId = colonyId;
                buf.defaultColor = useColonyColour ? colonyColours.computeIfAbsent(colonyId, id -> {
                    IColonyView colony = IMinecoloniesAPI.getInstance().getColonyManager().getColonyView((int)id, (ResourceKey<Level>)ctx.clientLevel.dimension());
                    ChatFormatting team = colony != null ? colony.getTeamColonyColor() : (id == playerColonyId ? ChatFormatting.WHITE : ChatFormatting.RED);
                    return new ColourARGB(team.getColor() | 0xFF000000).asQuartet();
                }) : (colonyId == playerColonyId ? new ColourQuartet(255, 255, 255, 255) : new ColourQuartet(255, 70, 70, 255));
                mutableChunkPos.setX(chunkPos.x);
                mutableChunkPos.setZ(chunkPos.z - 1);
                boolean north = mapToDraw.getOrDefault((Object)mutableChunkPos, -1) != testedColonyId;
                mutableChunkPos.setZ(chunkPos.z + 1);
                boolean south = mapToDraw.getOrDefault((Object)mutableChunkPos, -1) != testedColonyId;
                mutableChunkPos.setX(chunkPos.x + 1);
                mutableChunkPos.setZ(chunkPos.z);
                boolean east = mapToDraw.getOrDefault((Object)mutableChunkPos, -1) != testedColonyId;
                mutableChunkPos.setX(chunkPos.x - 1);
                boolean bl = west = mapToDraw.getOrDefault((Object)mutableChunkPos, -1) != testedColonyId;
                if (north || west) {
                    buf.addVertex(minX, (float)minY, minZ).setDefaultColor();
                    buf.addVertex(minX, (float)maxY, minZ).setDefaultColor();
                }
                if (north || east) {
                    buf.addVertex(maxX, (float)minY, minZ).setDefaultColor();
                    buf.addVertex(maxX, (float)maxY, minZ).setDefaultColor();
                }
                if (south || west) {
                    buf.addVertex(minX, (float)minY, maxZ).setDefaultColor();
                    buf.addVertex(minX, (float)maxY, maxZ).setDefaultColor();
                }
                if (south || east) {
                    buf.addVertex(maxX, (float)minY, maxZ).setDefaultColor();
                    buf.addVertex(maxX, (float)maxY, maxZ).setDefaultColor();
                }
                if (north) {
                    if (isPlayerChunkX) {
                        for (shift = 4; shift < 16; shift += 4) {
                            buf.addVertex(minX + (float)shift, (float)minY, minZ).setDefaultColor();
                            buf.addVertex(minX + (float)shift, (float)maxY, minZ).setDefaultColor();
                        }
                        for (y = minY + 4; y < maxY; y += 4) {
                            buf.addVertex(minX, (float)y, minZ).setDefaultColor();
                            buf.addVertex(maxX, (float)y, minZ).setDefaultColor();
                        }
                    } else {
                        for (y = minY + 16; y < maxY; y += 16) {
                            buf.addVertex(minX, (float)y, minZ).setDefaultColor();
                            buf.addVertex(maxX, (float)y, minZ).setDefaultColor();
                        }
                    }
                }
                if (south) {
                    if (isPlayerChunkX) {
                        for (shift = 4; shift < 16; shift += 4) {
                            buf.addVertex(minX + (float)shift, (float)minY, maxZ).setDefaultColor();
                            buf.addVertex(minX + (float)shift, (float)maxY, maxZ).setDefaultColor();
                        }
                        for (y = minY + 4; y < maxY; y += 4) {
                            buf.addVertex(minX, (float)y, maxZ).setDefaultColor();
                            buf.addVertex(maxX, (float)y, maxZ).setDefaultColor();
                        }
                    } else {
                        for (y = minY + 16; y < maxY; y += 16) {
                            buf.addVertex(minX, (float)y, maxZ).setDefaultColor();
                            buf.addVertex(maxX, (float)y, maxZ).setDefaultColor();
                        }
                    }
                }
                if (west) {
                    if (isPlayerChunkZ) {
                        for (shift = 4; shift < 16; shift += 4) {
                            buf.addVertex(minX, (float)minY, minZ + (float)shift).setDefaultColor();
                            buf.addVertex(minX, (float)maxY, minZ + (float)shift).setDefaultColor();
                        }
                        for (y = minY + 4; y < maxY; y += 4) {
                            buf.addVertex(minX, (float)y, minZ).setDefaultColor();
                            buf.addVertex(minX, (float)y, maxZ).setDefaultColor();
                        }
                    } else {
                        for (y = minY + 16; y < maxY; y += 16) {
                            buf.addVertex(minX, (float)y, minZ).setDefaultColor();
                            buf.addVertex(minX, (float)y, maxZ).setDefaultColor();
                        }
                    }
                }
                if (!east) break block28;
                if (isPlayerChunkZ) {
                    for (shift = 4; shift < 16; shift += 4) {
                        buf.addVertex(maxX, (float)minY, minZ + (float)shift).setDefaultColor();
                        buf.addVertex(maxX, (float)maxY, minZ + (float)shift).setDefaultColor();
                    }
                    for (y = minY + 4; y < maxY; y += 4) {
                        buf.addVertex(maxX, (float)y, minZ).setDefaultColor();
                        buf.addVertex(maxX, (float)y, maxZ).setDefaultColor();
                    }
                } else {
                    for (y = minY + 16; y < maxY; y += 16) {
                        buf.addVertex(maxX, (float)y, minZ).setDefaultColor();
                        buf.addVertex(maxX, (float)y, maxZ).setDefaultColor();
                    }
                }
            }
        });
        MeshData renderedBuffer = bufferbuilder.build();
        if (renderedBuffer == null) {
            return null;
        }
        VertexBuffer vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        vertexBuffer.bind();
        vertexBuffer.upload(renderedBuffer);
        VertexBuffer.unbind();
        return vertexBuffer;
    }

    public static void cleanup() {
        if (colonies != null) {
            colonies.close();
        }
        if (chunktickets != null) {
            chunktickets.close();
        }
        lastColony = null;
        lastPlayerChunkPos = null;
    }
}

