/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render;

import com.minecolonies.api.blocks.huts.AbstractBlockMinecoloniesDefault;
import com.minecolonies.api.tileentities.AbstractTileEntityScarecrow;
import com.minecolonies.api.tileentities.ScareCrowType;
import com.minecolonies.core.blocks.BlockScarecrow;
import com.minecolonies.core.client.model.ScarecrowModel;
import com.minecolonies.core.event.ClientRegistryHandler;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityScarecrowRenderer
implements BlockEntityRenderer<AbstractTileEntityScarecrow> {
    private static final double BLOCK_MIDDLE = 0.5;
    private static final double YOFFSET = 1.5;
    private static final int ROTATION = 180;
    private static final int BASIC_ROTATION = 90;
    private static final int ROTATE_EAST = 1;
    private static final int ROTATE_SOUTH = 2;
    private static final int ROTATE_WEST = 3;
    @NotNull
    private ScarecrowModel model;
    public static final Material SCARECROW_A = new Material(InventoryMenu.BLOCK_ATLAS, new ResourceLocation("minecolonies", "block/blockscarecrowpumpkin"));
    public static final Material SCARECROW_B = new Material(InventoryMenu.BLOCK_ATLAS, new ResourceLocation("minecolonies", "block/blockscarecrownormal"));

    public TileEntityScarecrowRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new ScarecrowModel(context.bakeLayer(ClientRegistryHandler.SCARECROW));
    }

    public void render(AbstractTileEntityScarecrow te, float partialTicks, PoseStack matrixStack, @NotNull MultiBufferSource iRenderTypeBuffer, int lightA, int lightB) {
        if (te.getBlockState().getValue(BlockScarecrow.HALF) == DoubleBlockHalf.UPPER) {
            return;
        }
        matrixStack.pushPose();
        matrixStack.translate(0.5, 1.5, 0.5);
        matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        if (te.getLevel().getBlockState(te.getBlockPos()).getBlock() instanceof BlockScarecrow) {
            Direction facing = (Direction)te.getLevel().getBlockState(te.getBlockPos()).getValue((Property)AbstractBlockMinecoloniesDefault.FACING);
            switch (facing) {
                case EAST: {
                    matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                    break;
                }
                case SOUTH: {
                    matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                    break;
                }
                case WEST: {
                    matrixStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                    break;
                }
            }
        }
        VertexConsumer vertexConsumer = TileEntityScarecrowRenderer.getMaterial(te).buffer(iRenderTypeBuffer, RenderType::entitySolid);
        this.model.renderToBuffer(matrixStack, vertexConsumer, lightA, lightB, -1);
        matrixStack.popPose();
    }

    @NotNull
    private static Material getMaterial(@NotNull AbstractTileEntityScarecrow tileEntity) {
        if (tileEntity.getScarecrowType() == ScareCrowType.PUMPKINHEAD) {
            return SCARECROW_A;
        }
        return SCARECROW_B;
    }
}

