/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render;

import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import com.minecolonies.core.tileentities.TileEntityEnchanter;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityEnchanterRenderer
implements BlockEntityRenderer<TileEntityColonyBuilding> {
    public static final Material TEXTURE_BOOK = new Material(InventoryMenu.BLOCK_ATLAS, new ResourceLocation("minecolonies", "block/enchanting_table_book"));
    private final BookModel modelBook;

    public TileEntityEnchanterRenderer(BlockEntityRendererProvider.Context context) {
        this.modelBook = new BookModel(context.bakeLayer(ModelLayers.BOOK));
    }

    public void render(@NotNull TileEntityColonyBuilding ent, float partialTicks, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource renderTypeBuffer, int lightA, int lightB) {
        if (ent instanceof TileEntityEnchanter) {
            TileEntityEnchanter entity = (TileEntityEnchanter)ent;
            matrixStack.pushPose();
            matrixStack.translate(0.5, 0.75, 0.5);
            float tick = (float)entity.tickCount + partialTicks;
            matrixStack.translate(0.0, (double)(0.1f + Mth.sin((float)(tick * 0.1f)) * 0.01f), 0.0);
            double rotVPrev = entity.bookRotation - entity.bookRotationPrev;
            float circleRot = (float)(rotVPrev + Math.PI - Math.PI);
            float tickBasedRot = entity.bookRotationPrev + circleRot * partialTicks;
            matrixStack.mulPose(Axis.YP.rotation(-tickBasedRot));
            matrixStack.mulPose(Axis.ZP.rotationDegrees(80.0f));
            float pageFlip = Mth.lerp((float)partialTicks, (float)entity.pageFlipPrev, (float)entity.pageFlip);
            float flipA = Mth.frac((float)(pageFlip + 0.25f)) * 1.6f - 0.3f;
            float flipB = Mth.frac((float)(pageFlip + 0.75f)) * 1.6f - 0.3f;
            float bookSpread = Mth.lerp((float)partialTicks, (float)entity.bookSpreadPrev, (float)entity.bookSpread);
            this.modelBook.setupAnim(tick, Mth.clamp((float)flipA, (float)0.0f, (float)1.0f), Mth.clamp((float)flipB, (float)0.0f, (float)1.0f), bookSpread);
            VertexConsumer vertexConsumer = TEXTURE_BOOK.buffer(renderTypeBuffer, RenderType::entitySolid);
            this.modelBook.renderToBuffer(matrixStack, vertexConsumer, lightA, lightB);
            matrixStack.popPose();
        }
    }
}

