/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render;

import com.minecolonies.core.client.model.SpearModel;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpearItemTileEntityRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("minecolonies", "textures/entity/spear.png");
    private SpearModel model;
    private final EntityModelSet set = Minecraft.getInstance().getEntityModels();

    public SpearItemTileEntityRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
        this.model = new SpearModel(this.set.bakeLayer(ModelLayers.TRIDENT));
    }

    public void onResourceManagerReload(ResourceManager manager) {
        this.model = new SpearModel(this.set.bakeLayer(ModelLayers.TRIDENT));
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        matrixStack.pushPose();
        this.model.renderToBuffer(matrixStack, ItemRenderer.getFoilBuffer((MultiBufferSource)buffer, (RenderType)this.model.renderType(TEXTURE), (boolean)false, (boolean)stack.hasFoil()), combinedLight, combinedOverlay, -1);
        matrixStack.popPose();
    }
}

